/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.jthemedetecor.WindowsThemeDetector;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(WindowsThemeDetector.class);
    private static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    private static final String REGISTRY_VALUE = "AppsUseLightTheme";
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private DetectorThread detectorThread;

    WindowsThemeDetector() {
    }

    public boolean isDark() {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
    }

    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener);
        boolean listenerAdded = this.listeners.add(darkThemeListener);
        boolean singleListener = listenerAdded && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (singleListener || threadInterrupted) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    public synchronized void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }
}

