/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfDocfmt;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfHeader;
import com.tutego.jrtf.RtfHeaderColor;
import com.tutego.jrtf.RtfHeaderFont;
import com.tutego.jrtf.RtfHeaderStyle;
import com.tutego.jrtf.RtfInfo;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfSectionFormatAndHeaderFooter;
import com.tutego.jrtf.RtfTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class Rtf {
    static final Charset charset = Charset.forName("Windows-1252");
    static final CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    static final String CHARSET1252 = charset.name();
    private final SortedMap<Integer, RtfHeaderColor> headerColors = new TreeMap();
    private final List<RtfHeaderFont> headerFonts = new ArrayList();
    private final List<RtfHeaderStyle> headerStyles = new ArrayList();
    private final StringBuilder info = new StringBuilder();
    private final StringBuilder docfmt = new StringBuilder();
    private final List<CharSequence> secfmtHdrftrs = new ArrayList();
    private final List<RtfPara[]> sectionParagraphs = new ArrayList();

    private Rtf() {
    }

    public static Rtf rtf() {
        return new Rtf();
    }

    static void asRtf(Appendable out, String rawText) throws IOException {
        for (int i = 0; i < rawText.length(); ++i) {
            char c = rawText.charAt(i);
            if (c == '\n') {
                out.append("\\par\n");
                continue;
            }
            if (c == '\t') {
                out.append("\\tab\n");
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c == '{') {
                out.append("\\{");
                continue;
            }
            if (c == '}') {
                out.append("\\}");
                continue;
            }
            if (c < '\u007f') {
                out.append(c);
                continue;
            }
            out.append("\\u").append(Integer.toString(c)).append(Rtf.escapeWindows1252((char)c));
        }
    }

    static String asRtf(String rawText) {
        if (rawText == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(rawText.length() * 2);
        try {
            Rtf.asRtf((Appendable)result, (String)rawText);
        }
        catch (IOException e) {
            throw new RtfException((Throwable)e);
        }
        return result.toString();
    }

    public static RtfTemplate template(InputStream inputStream) {
        return new RtfTemplate(inputStream);
    }

    static StringBuilder frameRtfParagraphWithEndingPar(String rtfControlWord, RtfPara para) {
        try {
            StringBuilder out = new StringBuilder(1024);
            out.append("{\\");
            out.append(rtfControlWord);
            para.rtf((Appendable)out, true);
            out.append('}');
            return out;
        }
        catch (IOException e) {
            throw new RtfException((Throwable)e);
        }
    }

    static String escapeWindows1252(char c) {
        if (!charsetEncoder.canEncode(c)) {
            return "?";
        }
        try {
            ByteBuffer bytes = charsetEncoder.encode(CharBuffer.wrap(String.valueOf(c)));
            int unsignedCharByte = bytes.get() & 0xFF;
            return String.format("\\'%02x", unsignedCharByte);
        }
        catch (CharacterCodingException err) {
            throw new RtfException((Throwable)err);
        }
    }

    public Rtf header(RtfHeader ... headers) {
        for (RtfHeader rtfHeader : headers) {
            if (rtfHeader instanceof RtfHeaderColor) {
                this.headerColors.put(((RtfHeaderColor)rtfHeader).colorindex, (RtfHeaderColor)rtfHeader);
                continue;
            }
            if (!(rtfHeader instanceof RtfHeaderFont)) continue;
            this.headerFonts.add((RtfHeaderFont)rtfHeader);
        }
        return this;
    }

    public Rtf headerStyles(RtfHeaderStyle ... styles) {
        for (RtfHeaderStyle rtfStyle : styles) {
            if (this.headerStyles.contains(rtfStyle)) continue;
            this.headerStyles.add(rtfStyle);
        }
        return this;
    }

    public Rtf info(RtfInfo ... infos) {
        for (RtfInfo rtfInfo : infos) {
            this.info.append(rtfInfo.rtf);
        }
        return this;
    }

    public Rtf documentFormatting(RtfDocfmt ... documentFormattings) {
        for (RtfDocfmt rtfDocfmt : documentFormattings) {
            this.docfmt.append(rtfDocfmt.rtf);
        }
        return this;
    }

    public Rtf section(RtfPara ... paragraphs) {
        return this.section(null, paragraphs);
    }

    public Rtf section(Collection<RtfPara> paragraphs) {
        return this.section(null, paragraphs.toArray(new RtfPara[paragraphs.size()]));
    }

    public Rtf section(RtfSectionFormatAndHeaderFooter secfmtHdrftr, RtfPara ... paragraphs) {
        if (paragraphs == null) {
            throw new IllegalArgumentException("There has to be atleast one paragraph in a section");
        }
        if (secfmtHdrftr != null) {
            this.secfmtHdrftrs.add(secfmtHdrftr.rtf);
        } else {
            this.secfmtHdrftrs.add(null);
        }
        this.sectionParagraphs.add(paragraphs);
        return this;
    }

    public Rtf p(Object ... texts) {
        return this.section(new RtfPara[]{RtfPara.p((Object[])texts)});
    }

    public Rtf p(RtfHeaderStyle style, Object ... texts) {
        return this.section(new RtfPara[]{RtfPara.p((RtfHeaderStyle)style, (Object[])texts)});
    }

    public void out(Appendable out) {
        block12: {
            if (out == null) {
                throw new IllegalArgumentException("Appendable is not allowed to be null");
            }
            Object rtfException = null;
            if (out instanceof Closeable) {
                try (Closeable o = (Closeable)((Object)out);){
                    this.writeRtfDocument(out);
                    break block12;
                }
                catch (IOException e) {
                    throw new RtfException((Throwable)e);
                }
            }
            try {
                this.writeRtfDocument(out);
            }
            catch (IOException e) {
                throw new RtfException((Throwable)e);
            }
        }
    }

    public CharSequence out() {
        StringBuilder result = new StringBuilder(4096);
        this.out((Appendable)result);
        return result;
    }

    public String toString() {
        return this.out().toString();
    }

    private void writeRtfDocument(Appendable out) throws IOException {
        out.append("{");
        out.append("\\rtf1\\ansi\\deff0");
        out.append("\n{\\fonttbl");
        if (this.headerFonts.isEmpty()) {
            out.append("{\\f0 Times New Roman;}");
        } else {
            for (RtfHeaderFont font : this.headerFonts) {
                font.writeFontInfo(out);
            }
        }
        out.append('}');
        if (!this.headerColors.isEmpty()) {
            out.append("\n{\\colortbl");
            int maxColorIndex = (Integer)this.headerColors.lastKey();
            for (int i = 0; i <= maxColorIndex; ++i) {
                RtfHeaderColor color = (RtfHeaderColor)this.headerColors.get(i);
                if (color == null) {
                    out.append(';');
                    continue;
                }
                color.writeColordef(out);
            }
            out.append('}');
        } else {
            out.append("\n{\\colortbl;}");
        }
        if (!this.headerStyles.isEmpty()) {
            out.append("\n{\\stylesheet");
            for (RtfHeaderStyle style : this.headerStyles) {
                out.append(style.toString());
            }
            out.append('}');
        }
        out.append('\n');
        if (!this.info.isEmpty()) {
            out.append("{\\info");
            out.append(this.info);
            out.append("}\n");
        }
        if (!this.docfmt.isEmpty()) {
            out.append(this.docfmt);
        }
        for (int sectionCnt = 0; sectionCnt < this.sectionParagraphs.size(); ++sectionCnt) {
            RtfPara[] paragraphs = (RtfPara[])this.sectionParagraphs.get(sectionCnt);
            CharSequence secfmtHdrftr = (CharSequence)this.secfmtHdrftrs.get(sectionCnt);
            if (secfmtHdrftr != null) {
                out.append(secfmtHdrftr);
            }
            for (RtfPara rtfPara : paragraphs) {
                rtfPara.rtf(out, true);
            }
            if (sectionCnt == this.sectionParagraphs.size() - 1) continue;
            out.append("\\sect\n");
        }
        out.append("}");
    }
}

