/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfUnit;

public class RtfSectionFormatAndHeaderFooter {
    final CharSequence rtf;

    private RtfSectionFormatAndHeaderFooter(CharSequence rtf) {
        this.rtf = rtf;
    }

    public static RtfSectionFormatAndHeaderFooter sectionFormatting(RtfSectionFormatAndHeaderFooter ... sectionFormats) {
        StringBuilder sb = new StringBuilder(sectionFormats.length * 10);
        for (RtfSectionFormatAndHeaderFooter rtfSectionFormat : sectionFormats) {
            sb.append(rtfSectionFormat.rtf);
        }
        return new RtfSectionFormatAndHeaderFooter((CharSequence)sb);
    }

    public static RtfSectionFormatAndHeaderFooter reset() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\sectd");
    }

    public static RtfSectionFormatAndHeaderFooter endnotesIncluded() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\endnhere");
    }

    public static RtfSectionFormatAndHeaderFooter noBreak() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\sbknone");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewColumn() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\sbkcol");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewPage() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\sbkpage");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewEvenPage() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\sbkeven");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewOddPage() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\sbkodd");
    }

    public static RtfSectionFormatAndHeaderFooter columns(int columns) {
        if (columns <= 0) {
            throw new RtfException("Number of colums can't be <= 0");
        }
        return new RtfSectionFormatAndHeaderFooter((CharSequence)("\\cols" + columns));
    }

    public static RtfSectionFormatAndHeaderFooter spaceBetweenColumns(double space, RtfUnit unit) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)("\\colsx" + unit.toTwips(space)));
    }

    public static RtfSectionFormatAndHeaderFooter lineBetweenColumns() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\linebetcol");
    }

    public static RtfSectionFormatAndHeaderFooter beginningPageNumber(int pageNumber) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)("\\pgnstarts" + pageNumber));
    }

    public static RtfSectionFormatAndHeaderFooter topAlignText() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\vertalt");
    }

    public static RtfSectionFormatAndHeaderFooter bottomAlignText() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\vertalb");
    }

    public static RtfSectionFormatAndHeaderFooter centerVerticalText() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\vertalc");
    }

    public static RtfSectionFormatAndHeaderFooter justifyVerticalText() {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)"\\vertalj");
    }

    public static RtfSectionFormatAndHeaderFooter headerForAllPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)Rtf.frameRtfParagraphWithEndingPar((String)"header", (RtfPara)para));
    }

    public static RtfSectionFormatAndHeaderFooter headerForLeftHandPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)Rtf.frameRtfParagraphWithEndingPar((String)"headerl", (RtfPara)para));
    }

    public static RtfSectionFormatAndHeaderFooter headerForRightHandPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)Rtf.frameRtfParagraphWithEndingPar((String)"headerr", (RtfPara)para));
    }

    public static RtfSectionFormatAndHeaderFooter headerForFirstPage(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)Rtf.frameRtfParagraphWithEndingPar((String)"headerf", (RtfPara)para));
    }

    public static RtfSectionFormatAndHeaderFooter footerOnAllPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter((CharSequence)Rtf.frameRtfParagraphWithEndingPar((String)"footer", (RtfPara)para));
    }
}

