/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3;

import com.jthemedetecor.util.OsInfo;
import eu.ewerkzeug.easytranscript3.BootstrapService;
import eu.ewerkzeug.easytranscript3.commons.LogUploadService;
import eu.ewerkzeug.easytranscript3.commons.RuntimeUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javafx.scene.control.Alert;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class BootstrapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapService.class);
    private final String RELATIVE_MAC_JNA_LIB_PATH = "Contents/Resources";
    private final ConfigurationService configurationService;
    private final LogUploadService logUploadService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final ExceptionAlert exceptionAlert;

    protected void start() {
        this.greeting();
        this.getSystemInformation();
        this.checkDirectoryStructure();
        this.prepareJNA();
        this.uploadQueuedLogs();
    }

    private void prepareJNA() {
        log.debug("Preparing jna ...");
        log.debug("Is MacOS: {}", (Object)OsInfo.isMacOsMojaveOrLater());
        Path path = Paths.get("Contents/Resources", new String[0]);
        log.debug("Does jna lib exists relative to jar: {}", (Object)Files.exists(path, new LinkOption[0]));
        try {
            log.debug("JNA Lib search path: {}", (Object)path.toFile().getCanonicalPath());
        }
        catch (IOException e) {
            log.debug("JNA Lib search path is invalid.");
        }
        log.debug("Current Path: {}", (Object)Paths.get("", new String[0]).toAbsolutePath());
        if (OsInfo.isMacOsMojaveOrLater() && Files.exists(path, new LinkOption[0])) {
            System.setProperty("jna.nosys", "true");
            System.setProperty("jna.nounpack", "true");
            System.setProperty("jna.noclasspath", "true");
            System.setProperty("jna.debug_load.jna", "true");
            System.setProperty("jna.boot.library.path", "Contents/Resources");
        }
    }

    private void getSystemInformation() {
        File[] roots;
        Runtime runtime = Runtime.getRuntime();
        log.info("Java Home: {}", (Object)System.getProperty("java.home"));
        log.info("Java Version: {}", (Object)System.getProperty("java.version"));
        log.info("Java Vendor: {}", (Object)System.getProperty("java.vendor"));
        log.info("Java Architecture: {}", (Object)System.getProperty("os.arch"));
        log.info("Java Image Type: {} (bundled: {})", (Object)RuntimeUtils.getRuntimeProperties().getProperty(RuntimeUtils.ReleaseKey.IMAGE_TYPE.name()), (Object)RuntimeUtils.isBundledJRE());
        log.info("OS Name: {}", (Object)System.getProperty("os.name"));
        log.info("OS Version: {}", (Object)System.getProperty("os.version"));
        log.info("User Home: {}", (Object)System.getProperty("user.home"));
        log.info("User Directory: {}", (Object)System.getProperty("user.dir"));
        log.info("ET Home: {}", (Object)Configuration.ET_HOME);
        log.info("Memory (Used, Total, Max): {} MB/ {} MB/ {}MB", new Object[]{(runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L, runtime.maxMemory() / 0x100000L});
        log.info("CPU Cores: {}", (Object)Runtime.getRuntime().availableProcessors());
        for (File root : roots = File.listRoots()) {
            log.info("File system root: {}", (Object)root.getAbsolutePath());
            log.info("Total space (bytes): {} MB", (Object)(root.getTotalSpace() / 1024L / 1024L));
            log.info("Free space (bytes): {} MB", (Object)(root.getFreeSpace() / 1024L / 1024L));
            log.info("Usable space (bytes): {} MB", (Object)(root.getUsableSpace() / 1024L / 1024L));
        }
    }

    private void greeting() {
        log.info("easytranscript Version {} ({}), Build {}", new Object[]{this.configurationService.getVersion(), this.configurationService.getConfiguration().getChannel(), this.configurationService.getCommitIdOfVersion()});
        Locale.setDefault(Locale.forLanguageTag(this.configurationService.getConfiguration().getProgramLanguage()));
        log.debug(this.configurationService.getConfiguration().toString());
    }

    private void uploadQueuedLogs() {
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        CompletableFuture.runAsync((Runnable)task);
    }

    private void checkDirectoryStructure() {
        log.info("Checking directory structure ...");
        try {
            IOException e;
            Path core = this.getEtHome();
            Path logs = this.getEtHome().resolve("logs");
            Path backups = this.getEtHome().resolve("backups");
            Files.createDirectories(core, new FileAttribute[0]);
            Files.createDirectories(logs, new FileAttribute[0]);
            Files.createDirectories(backups, new FileAttribute[0]);
            if (!Files.isWritable(core)) {
                e = new IOException(String.valueOf(core) + " " + this.messageService.getLocaleBundle().getString("general.notWritable"));
                log.error("", (Throwable)e);
                this.dialogService.get(e.getMessage(), Alert.AlertType.ERROR).showAndWait();
            }
            if (!Files.isWritable(logs)) {
                e = new IOException(String.valueOf(logs) + " " + this.messageService.getLocaleBundle().getString("general.notWritable"));
                log.error("", (Throwable)e);
                this.dialogService.get(e.getMessage(), Alert.AlertType.ERROR).showAndWait();
            }
            if (!Files.isWritable(backups)) {
                e = new IOException(String.valueOf(backups) + " " + this.messageService.getLocaleBundle().getString("general.notWritable"));
                log.error("", (Throwable)e);
                this.dialogService.get(e.getMessage(), Alert.AlertType.ERROR).showAndWait();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
        }
        log.info("... Done.");
    }

    protected Path getEtHome() {
        return Path.of(Configuration.ET_HOME, new String[0]);
    }

    @Generated
    public BootstrapService(ConfigurationService configurationService, LogUploadService logUploadService, MessageService messageService, DialogService dialogService, ExceptionAlert exceptionAlert) {
        this.configurationService = configurationService;
        this.logUploadService = logUploadService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.exceptionAlert = exceptionAlert;
    }
}

