/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3;

import eu.ewerkzeug.easytranscript3.BootstrapService;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.SpringBootJavaFxApplication;
import eu.ewerkzeug.easytranscript3.StageReadyEvent;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.migrations.MigrationService;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxWeaver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PrimaryStageInitializer
implements ApplicationListener<StageReadyEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrimaryStageInitializer.class);
    private final FxWeaver fxWeaver;
    private final MigrationService migrationService;
    private final ExecutorService executorService;
    private final BootstrapService bootstrapService;
    private final MessageService messageService;
    private final TranscriptService transcriptService;
    private final GuiStateService guiStateService;

    public void onApplicationEvent(@NotNull StageReadyEvent event) {
        this.bootstrapService.start();
        this.executorService.submit(Utils::deleteAllLeftOverTempFiles);
        this.migrationService.runProgramMigrations();
        log.debug("Setting main stage ...");
        this.guiStateService.setMainStage(event.stage);
        this.guiStateService.setSplashScreenStage(this.getSplashScreenStage());
        ExtendedController controller = this.loadControllerBasedOnStageUserData(event.stage);
        controller.loadTitle();
        this.guiStateService.setController(controller);
        this.guiStateService.setFree(false);
    }

    public Stage getSplashScreenStage() {
        return SpringBootJavaFxApplication.getSplashScreenStage();
    }

    private ExtendedController loadControllerBasedOnStageUserData(@NotNull Stage stage) {
        List data;
        log.debug("User data of this stage: {}", stage.getUserData());
        if (stage.getUserData() instanceof List && !(data = (List)stage.getUserData()).isEmpty()) {
            this.transcriptService.getCurrentTranscript().setTranscriptLocation(Path.of((String)data.getFirst(), new String[0]));
        }
        return (ExtendedController)this.fxWeaver.loadController(MainController.class, this.messageService.getLocaleBundle());
    }

    @Generated
    public PrimaryStageInitializer(FxWeaver fxWeaver, MigrationService migrationService, ExecutorService executorService, BootstrapService bootstrapService, MessageService messageService, TranscriptService transcriptService, GuiStateService guiStateService) {
        this.fxWeaver = fxWeaver;
        this.migrationService = migrationService;
        this.executorService = executorService;
        this.bootstrapService = bootstrapService;
        this.messageService = messageService;
        this.transcriptService = transcriptService;
        this.guiStateService = guiStateService;
    }
}

