/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3;

import com.jthemedetecor.OsThemeDetector;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.SplashScreen;
import eu.ewerkzeug.easytranscript3.StageReadyEvent;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringBootJavaFxApplication
extends Application {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringBootJavaFxApplication.class);
    private static SpringBootJavaFxApplication application;
    private static Stage splashScreenStage;
    private ConfigurableApplicationContext context;

    public void init() {
        application = this;
        Platform.runLater(() -> {
            SplashScreen splashScreen = new SplashScreen();
            Stage stage = new Stage(StageStyle.TRANSPARENT);
            boolean isDark = false;
            try {
                isDark = OsThemeDetector.getDetector().isDark();
            }
            catch (Exception e) {
                log.warn("Could not detect OS theme, using light icons.");
            }
            String folder = isDark ? "light" : "dark";
            for (int size : List.of(Integer.valueOf(16), Integer.valueOf(32), Integer.valueOf(64), Integer.valueOf(96), Integer.valueOf(512))) {
                String path = "/images/" + folder + "/favicon_" + size + ".png";
                InputStream iconStream = this.getClass().getResourceAsStream(path);
                if (iconStream == null) continue;
                stage.getIcons().add((Object)new Image(iconStream));
            }
            Scene scene = new Scene(splashScreen.getParent());
            scene.setFill((Paint)Color.TRANSPARENT);
            stage.setScene(scene);
            stage.show();
            Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
            stage.setX((primScreenBounds.getWidth() - stage.getWidth()) / 2.0);
            stage.setY((primScreenBounds.getHeight() - stage.getHeight()) / 2.0);
            splashScreenStage = stage;
        });
        this.context = new SpringApplicationBuilder(new Class[0]).headless(false).sources(new Class[]{Main.class}).run(this.getParameters().getRaw().toArray(new String[0]));
    }

    public void start(Stage primaryStage) {
        try {
            primaryStage.setUserData((Object)this.getOpenFiles());
            this.context.publishEvent((ApplicationEvent)new StageReadyEvent(primaryStage));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private List<String> getOpenFiles() {
        return this.getParameters().getUnnamed();
    }

    public void stop() {
        try {
            this.dispose();
        }
        catch (Exception e) {
            log.error("Could not dispose.", (Throwable)e);
        }
        log.info("Closing context ...");
        this.context.close();
        log.info("Context closed.");
        log.debug("{} Threads still active.", (Object)Thread.activeCount());
        Thread.getAllStackTraces().forEach((key, value) -> {
            log.debug("");
            log.debug("{} - {} - {}", new Object[]{key.getName(), key.getClass().getName(), key.getState()});
            for (StackTraceElement stackTraceElement : value) {
                log.debug(stackTraceElement.toString());
            }
        });
        log.info("Bye.");
        System.exit(0);
    }

    public void dispose() {
        log.info("Stopping...");
        if (Main.getPlayer() != null) {
            Main.getPlayer().release();
        }
        ((ConfigurationService)this.context.getBean(ConfigurationService.class)).save();
        LicenseService.getDisposableHashMap().values().forEach(disposable -> {
            if (!disposable.isDisposed()) {
                log.info("Stopping undisposed request.");
                disposable.dispose();
            }
        });
        try {
            STTStatusService statusService = (STTStatusService)this.context.getBean(STTStatusService.class);
            STTDeletionService deletionService = (STTDeletionService)this.context.getBean(STTDeletionService.class);
            TranscriptService transcriptService = (TranscriptService)this.context.getBean(TranscriptService.class);
            deletionService.cancelAllOngoingTransfers();
            Utils.clearTmp((Path)transcriptService.getTemporaryTranscriptsLocation());
            log.debug("Deleting transcription job with interrupted upload, if any.");
            if (statusService.isUploading()) {
                log.debug("Upload was interrupted, deleting transcription job ...");
                deletionService.deleteTranscriptionJob().block();
            }
        }
        catch (BeansException e) {
            log.error("Could not get status service bean.", (Throwable)e);
        }
    }

    @Generated
    public static SpringBootJavaFxApplication getApplication() {
        return application;
    }

    @Generated
    public static Stage getSplashScreenStage() {
        return splashScreenStage;
    }

    @Generated
    public ConfigurableApplicationContext getContext() {
        return this.context;
    }
}

