/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.Keyring;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.service.EncryptionService;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class CredentialsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CredentialsService.class);
    public static final String KEYRING_SERVICE_NAME = "easytranscript3";
    public static final String KEYRING_ACCOUNT_NAME = "LicenseAuth";
    public static final String KEYRING_ACCOUNT_DEVICE_ID = "DeviceId";
    private final EncryptionService encryptionService;
    private Pair<String, String> cachedLicenseCredentials;

    public CredentialsService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public boolean isKeyringSupportedPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        return !os.contains("mac");
    }

    protected Path getCredsPath() {
        return Path.of(Configuration.ET_HOME, new String[0]).resolve(".creds");
    }

    protected Path getDeviceIdPath() {
        return Path.of(Configuration.ET_HOME, new String[0]).resolve(".instance_info.dat");
    }

    public void storeCredentials(byte[] auth) throws IOException {
        if (!this.isKeyringSupportedPlatform()) {
            this.storeInFile(auth);
            this.updateCachedCredentials(auth);
            return;
        }
        try (Keyring keyring = Keyring.create();){
            String payload = Base64.getEncoder().encodeToString(auth);
            keyring.setPassword(KEYRING_SERVICE_NAME, KEYRING_ACCOUNT_NAME, payload);
            log.info("Credentials stored in system keyring.");
            this.updateCachedCredentials(auth);
        }
        catch (BackendNotSupportedException e) {
            log.warn("System keyring not supported. Falling back to file storage.", (Throwable)e);
            this.storeInFile(auth);
            this.updateCachedCredentials(auth);
        }
        catch (Exception e) {
            log.error("Failed to access system keyring to store credentials. Falling back to file storage.", (Throwable)e);
            this.storeInFile(auth);
            this.updateCachedCredentials(auth);
        }
    }

    private void updateCachedCredentials(byte[] auth) {
        try {
            this.cachedLicenseCredentials = auth != null ? (Pair)this.encryptionService.decrypt(auth) : null;
        }
        catch (Exception e) {
            log.error("Could not decrypt credentials for cache update.", (Throwable)e);
            this.cachedLicenseCredentials = null;
        }
    }

    private void storeInFile(byte[] auth) throws IOException {
        Path path = this.getCredsPath();
        Files.write(path, auth, new OpenOption[0]);
        Utils.markAsHidden((Path)path);
    }

    public void clearCredentials() throws IOException {
        if (this.isKeyringSupportedPlatform()) {
            try (Keyring keyring = Keyring.create();){
                keyring.deletePassword(KEYRING_SERVICE_NAME, KEYRING_ACCOUNT_NAME);
            }
            catch (Exception e) {
                log.warn("Could not delete credentials from keyring", (Throwable)e);
            }
        }
        Files.deleteIfExists(this.getCredsPath());
        this.cachedLicenseCredentials = null;
    }

    public byte[] getCredentials() {
        Path path;
        block14: {
            if (this.isKeyringSupportedPlatform()) {
                byte[] byArray;
                block13: {
                    Keyring keyring = Keyring.create();
                    try {
                        String payload = keyring.getPassword(KEYRING_SERVICE_NAME, KEYRING_ACCOUNT_NAME);
                        byArray = Base64.getDecoder().decode(payload);
                        if (keyring == null) break block13;
                    }
                    catch (Throwable payload) {
                        try {
                            if (keyring != null) {
                                try {
                                    keyring.close();
                                }
                                catch (Throwable throwable) {
                                    payload.addSuppressed(throwable);
                                }
                            }
                            throw payload;
                        }
                        catch (BackendNotSupportedException e) {
                            log.debug("Keyring not supported. Trying file fallback.");
                            break block14;
                        }
                        catch (Exception e) {
                            log.info("No credentials found in keyring or access denied. Trying file fallback.");
                        }
                    }
                    keyring.close();
                }
                return byArray;
            }
        }
        if (Files.exists(path = this.getCredsPath(), new LinkOption[0])) {
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException e) {
                log.error("Failed to read credentials from file", (Throwable)e);
            }
        }
        return null;
    }

    public Pair<String, String> getLicenseCredentials() {
        if (this.cachedLicenseCredentials != null) {
            return this.cachedLicenseCredentials;
        }
        byte[] credentials = this.getCredentials();
        if (credentials != null) {
            try {
                this.cachedLicenseCredentials = (Pair)this.encryptionService.decrypt(credentials);
                return this.cachedLicenseCredentials;
            }
            catch (Exception e) {
                log.error("Could not decrypt credentials.", (Throwable)e);
            }
        }
        return null;
    }

    public void storeDeviceId(String deviceId) {
        if (!this.isKeyringSupportedPlatform()) {
            this.storeDeviceIdInFile(deviceId);
            return;
        }
        try (Keyring keyring = Keyring.create();){
            keyring.setPassword(KEYRING_SERVICE_NAME, KEYRING_ACCOUNT_DEVICE_ID, deviceId);
            log.info("Device ID stored in system keyring.");
        }
        catch (BackendNotSupportedException e) {
            log.warn("System keyring not supported for Device ID. Falling back to file storage.", (Throwable)e);
            this.storeDeviceIdInFile(deviceId);
        }
        catch (Exception e) {
            log.error("Failed to access system keyring to store Device ID. Falling back to file storage.", (Throwable)e);
            this.storeDeviceIdInFile(deviceId);
        }
    }

    private void storeDeviceIdInFile(String deviceId) {
        try {
            byte[] encrypted = this.encryptionService.encrypt((Serializable)((Object)deviceId));
            Path path = this.getDeviceIdPath();
            Files.write(path, encrypted, new OpenOption[0]);
            Utils.markAsHidden((Path)path);
        }
        catch (IOException e) {
            log.error("Failed to store Device ID in fallback file", (Throwable)e);
            throw new RuntimeException("Could not store Device ID securely", e);
        }
    }

    public String getDeviceId() throws IOException {
        Path path;
        block12: {
            if (this.isKeyringSupportedPlatform()) {
                String string;
                block11: {
                    Keyring keyring = Keyring.create();
                    try {
                        string = keyring.getPassword(KEYRING_SERVICE_NAME, KEYRING_ACCOUNT_DEVICE_ID);
                        if (keyring == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (keyring != null) {
                                try {
                                    keyring.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (BackendNotSupportedException e) {
                            log.debug("Keyring not supported for Device ID. Trying file fallback.");
                            break block12;
                        }
                        catch (Exception e) {
                            log.info("No Device ID found in keyring or access denied. Trying file fallback.");
                        }
                    }
                    keyring.close();
                }
                return string;
            }
        }
        if (Files.exists(path = this.getDeviceIdPath(), new LinkOption[0])) {
            byte[] encrypted = Files.readAllBytes(path);
            return (String)this.encryptionService.decrypt(encrypted);
        }
        log.info("No device id found. Generating new one.");
        String newDeviceId = UUID.randomUUID().toString();
        this.storeDeviceId(newDeviceId);
        return newDeviceId;
    }

    public <T> Mono<T> executeAuthenticated(Function<Consumer<HttpHeaders>, Mono<T>> requestFunction) {
        Consumer deviceIdAuth = this.getDeviceIdAuthHeadersConsumer();
        log.info("Executing authenticated");
        if (deviceIdAuth == null) {
            log.warn("Could not get deviceId auth headers. Proceeding with full authentication directly.");
            Consumer fullAuth = this.getAuthHeadersForFullAuthenticationConsumer();
            if (fullAuth == null) {
                return Mono.error((Throwable)new IllegalStateException("Could not get any authentication headers."));
            }
            return requestFunction.apply(fullAuth);
        }
        return requestFunction.apply(deviceIdAuth).onErrorResume(e -> {
            WebClientResponseException wcre;
            if (e instanceof WebClientResponseException && ((wcre = (WebClientResponseException)e).getStatusCode().value() == 401 || wcre.getStatusCode().value() == 403)) {
                log.warn("Request with deviceId auth failed with status {}. Retrying with full authentication.", (Object)wcre.getStatusCode());
                Consumer fullAuth = this.getAuthHeadersForFullAuthenticationConsumer();
                if (fullAuth == null) {
                    try {
                        this.clearCredentials();
                    }
                    catch (IOException ex) {
                        log.error("Could not clear credentials.");
                    }
                    return Mono.error((Throwable)new IllegalStateException("Could not get full authentication headers for retry."));
                }
                return (Mono)requestFunction.apply(fullAuth);
            }
            return Mono.error((Throwable)e);
        });
    }

    public Consumer<HttpHeaders> getAuthHeadersForFullAuthenticationConsumer() {
        HashMap authHeaders = this.getAuthHeadersForFullAuthentication();
        if (authHeaders == null) {
            return null;
        }
        return headers -> {
            for (Map.Entry authHeader : authHeaders.entrySet()) {
                headers.add((String)authHeader.getKey(), (String)authHeader.getValue());
            }
        };
    }

    public Consumer<HttpHeaders> getDeviceIdAuthHeadersConsumer() {
        HashMap authHeaders = this.getDeviceIdAuthHeaders();
        if (authHeaders == null) {
            return null;
        }
        return headers -> {
            for (Map.Entry authHeader : authHeaders.entrySet()) {
                headers.add((String)authHeader.getKey(), (String)authHeader.getValue());
            }
        };
    }

    public HashMap<String, String> getDeviceIdAuthHeaders() {
        String deviceId;
        try {
            deviceId = this.getDeviceId();
        }
        catch (IOException e) {
            log.error("Could not retrieve deviceId", (Throwable)e);
            return null;
        }
        HashMap<String, String> returner = new HashMap<String, String>();
        returner.put("X-Device-ID", deviceId);
        return returner;
    }

    public HashMap<String, String> getAuthHeadersForFullAuthentication() {
        String deviceId;
        Pair authHeader = this.getAuthenticationHeader();
        if (authHeader == null) {
            return null;
        }
        try {
            deviceId = this.getDeviceId();
        }
        catch (IOException e) {
            log.error("Could not retrieve deviceId", (Throwable)e);
            return null;
        }
        HashMap<String, String> returner = new HashMap<String, String>();
        returner.put((String)authHeader.getKey(), (String)authHeader.getValue());
        returner.put("X-Device-ID", deviceId);
        return returner;
    }

    private Pair<String, String> getAuthenticationHeader() {
        Pair credentials = this.getLicenseCredentials();
        if (credentials == null) {
            log.error("No credentials saved.");
            return null;
        }
        String header = "Authorization";
        String headerValue = "Basic " + Base64.getEncoder().encodeToString(((String)credentials.getLeft() + ":" + (String)credentials.getRight()).getBytes(StandardCharsets.UTF_8));
        return ImmutablePair.of((Object)header, (Object)headerValue);
    }
}

