/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientResponseException;

@Service
@Lazy(value=false)
public class LogUploadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUploadService.class);
    private RestClient client;
    @Value(value="${easytranscript.loguploader-url}")
    private String logUploaderUrl;

    @PostConstruct
    public void init() {
        this.client = RestClient.create((String)this.logUploaderUrl);
        log.info("LogUploader initialized with URL: {}", (Object)this.logUploaderUrl);
    }

    public void upload() throws IOException {
        this.upload("easytranscript");
    }

    public void upload(String pattern) throws IOException {
        if (this.client == null) {
            log.error("LogUploader not initialized yet! Is the Spring Context running?");
            return;
        }
        String finalPattern = pattern + "\\.log";
        Path logFolder = this.getLogFolder();
        if (!Files.exists(logFolder, new LinkOption[0])) {
            log.debug("Log folder {} does not exist.", (Object)logFolder);
            return;
        }
        try (Stream<Path> stream = Files.walk(logFolder, new FileVisitOption[0]);){
            List<Path> files = stream.filter(p -> p.getFileName().toString().matches(finalPattern)).sorted(Comparator.comparingLong(p -> p.toFile().lastModified()).reversed()).limit(5L).toList();
            for (Path file : files) {
                this.performUpload(file);
            }
        }
    }

    protected Path getLogFolder() {
        return Path.of(Configuration.ET_HOME, "logs");
    }

    private void performUpload(Path file) {
        log.debug("Uploading {}", (Object)file.getFileName());
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("file", (Object)new FileSystemResource(file));
        MultiValueMap body = builder.build();
        try {
            ResponseEntity response = this.client.post().contentType(MediaType.MULTIPART_FORM_DATA).body((Object)body).retrieve().toBodilessEntity();
            if (response.getStatusCode().is2xxSuccessful()) {
                log.debug("Successfully uploaded {} (Status: {})", (Object)file.getFileName(), (Object)response.getStatusCode());
            } else {
                log.warn("Upload completed but returned non-success status for {}: {}", (Object)file.getFileName(), (Object)response.getStatusCode());
            }
        }
        catch (RestClientResponseException e) {
            log.error("Server rejected upload of {}: {} {} - Details: {}", new Object[]{file.getFileName(), e.getStatusCode(), e.getStatusText(), e.getResponseBodyAsString()});
        }
        catch (ResourceAccessException e) {
            log.error("Network error or timeout while uploading {}: {}", (Object)file.getFileName(), (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error during upload of {}: {}", new Object[]{file.getFileName(), e.getMessage(), e});
        }
    }

    @Generated
    public LogUploadService() {
    }
}

