/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SttLanguage;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.springframework.stereotype.Service;
import tools.jackson.databind.ObjectMapper;

@Service
public class SttLanguageService {
    private final ObjectMapper mapper;
    private List<String> azureTags;
    private List<SttLanguage> supportedAzureLanguages;

    @PostConstruct
    public void init() throws IOException {
        this.azureTags = Arrays.asList((String[])this.mapper.readValue(SttLanguageService.class.getResourceAsStream("/stt/languages-azure.json"), String[].class));
        this.supportedAzureLanguages = this.getSupportedLanguages();
    }

    private List<SttLanguage> getSupportedLanguages() {
        return this.azureTags.stream().map(tag -> {
            Locale locale = Locale.forLanguageTag(tag);
            return new SttLanguage(tag, locale.getDisplayName());
        }).toList();
    }

    public SttLanguage getLanguageByLabel(String label) {
        return this.supportedAzureLanguages.stream().filter(l -> l.label().equals(label)).findFirst().orElse(null);
    }

    public SttLanguage getLanguageByTag(String tag) {
        return this.supportedAzureLanguages.stream().filter(l -> l.tag().equals(tag)).findFirst().orElse(null);
    }

    @Generated
    public SttLanguageService(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Generated
    public List<SttLanguage> getSupportedAzureLanguages() {
        return this.supportedAzureLanguages;
    }
}

