/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.FXUiService;
import eu.ewerkzeug.easytranscript3.commons.fx.HighlightPane;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETTutorialModal;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.TutorialEvent;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Highlight;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialSection;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialStep;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxWeaver;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.reactfx.Change;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Either;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TutorialService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TutorialService.class);
    private final List<Subscription> subscriptions = new ArrayList();
    private final FXUiService fxUiService;
    private final ApplicationContext applicationContext;
    private final MessageService messageService;
    private final FxWeaver fxWeaver;
    private final GuiStateService gUIStateService;
    Map<Window, HighlightPane> highlightPaneMap = new HashMap();
    private Window owner;
    private ETTutorialModal etTutorialModal;

    public EventStream<TutorialEvent> show(Tutorial tutorial) {
        return this.showDialog(tutorial);
    }

    public <T extends Tutorial> T getTutorialBean(Class<T> tutorialClass) {
        return (T)((Tutorial)this.applicationContext.getBean(tutorialClass));
    }

    public <T extends Tutorial> EventStream<TutorialEvent> show(Class<T> tutorialClass) {
        Tutorial tutorial = this.getTutorialBean(tutorialClass);
        return this.show(tutorial);
    }

    public EventStream<TutorialEvent> showPopup(TutorialStep step) {
        if (step.getContent().getNextButtonText() == null || step.getContent().getNextButtonText().isBlank()) {
            step.getContent().setNextButtonText(this.messageService.getLocaleBundle().getString("general.alright"));
        }
        return this.showDialog((Tutorial)new /* Unavailable Anonymous Inner Class!! */);
    }

    public EventStream<TutorialEvent> showDialog(Tutorial tutorial) {
        TutorialSection startSection = tutorial.get();
        if (startSection == null || startSection.getSteps().isEmpty()) {
            return this.createErrorEventSource();
        }
        if (startSection.getCondition() != null) {
            log.error("The first section of a tutorial must be unconditional.");
            return this.createErrorEventSource();
        }
        this.owner = this.getHighlightOwner(((TutorialStep)startSection.getSteps().getFirst()).getHighlight());
        FxControllerAndView view = this.fxWeaver.load(ETTutorialModal.class, this.messageService.getLocaleBundle());
        this.etTutorialModal = (ETTutorialModal)view.getController();
        this.etTutorialModal.prepareAndShow(this.owner, startSection, tutorial.isPopup());
        this.handleStepIndexChange((Triple)new ImmutableTriple(null, (Object)((TutorialStep)startSection.getSteps().getFirst()), (Object)true));
        this.subscriptions.add(EventStreams.changesOf((ObservableValue)this.etTutorialModal.getCurrentStep()).or(EventStreams.changesOf((ObservableValue)this.etTutorialModal.getCurrentSection())).subscribe(change -> Platform.runLater(() -> this.handleStepIndexChange(this.getChangedSteps(change)))));
        this.etTutorialModal.getClosingEvents().subscribeForOne(closingEvent -> this.close(closingEvent, tutorial));
        return this.etTutorialModal.getClosingEvents();
    }

    private void close(TutorialEvent tutorialEvent, Tutorial tutorial) {
        tutorial.onEvent(tutorialEvent);
        this.removeBackdrops();
        this.subscriptions.forEach(Subscription::unsubscribe);
    }

    @NotNull
    private EventSource<TutorialEvent> createErrorEventSource() {
        EventSource eventSource = new EventSource();
        eventSource.push((Object)TutorialEvent.ERROR);
        return eventSource;
    }

    private void changeOwner(Window owner) {
        this.etTutorialModal.changeOwner(owner);
        this.owner = owner;
    }

    private void handleStepIndexChange(Triple<TutorialStep, TutorialStep, Boolean> idChange) {
        TutorialStep oldStep = (TutorialStep)idChange.getLeft();
        TutorialStep newStep = (TutorialStep)idChange.getMiddle();
        boolean jumpedForward = (Boolean)idChange.getRight();
        if (oldStep != null && oldStep.getFlowControl() != null) {
            Runnable r = jumpedForward ? oldStep.getFlowControl().getAfterNext() : oldStep.getFlowControl().getAfterBack();
            this.callSafely(r);
        }
        if (newStep != null) {
            Duration duration = null;
            if (newStep.getFlowControl() != null) {
                this.callSafely(newStep.getFlowControl().getBeforeShow());
                duration = newStep.getFlowControl().getWaitBeforeShow();
            }
            Runnable show = () -> {
                if (this.owner != this.getHighlightOwner(newStep.getHighlight())) {
                    this.changeOwner(this.getHighlightOwner(newStep.getHighlight()));
                }
                this.updateBackdrop(newStep.getHighlight());
                if (!this.etTutorialModal.isShowing()) {
                    this.etTutorialModal.show();
                }
            };
            if (duration != null) {
                FxTimer.runLater((Duration)duration, (Runnable)show);
            } else {
                show.run();
            }
        }
    }

    private Triple<TutorialStep, TutorialStep, Boolean> getChangedSteps(Either<Change<Number>, Change<TutorialSection>> idChange) {
        TutorialStep oldStep = null;
        TutorialStep newStep = null;
        boolean jumpedForward = false;
        if (idChange.isLeft()) {
            int oldId = ((Number)((Change)idChange.getLeft()).getOldValue()).intValue();
            int newId = ((Number)((Change)idChange.getLeft()).getNewValue()).intValue();
            List steps = ((TutorialSection)this.etTutorialModal.getCurrentSection().get()).getSteps();
            if (oldId >= 0 && oldId < steps.size()) {
                oldStep = (TutorialStep)steps.get(oldId);
            }
            if (newId >= 0 && newId < steps.size()) {
                newStep = (TutorialStep)steps.get(newId);
            }
            jumpedForward = newId > oldId;
        } else if (idChange.isRight()) {
            jumpedForward = this.etTutorialModal.getCurrentStep().get() == 0;
            TutorialSection previousSection = (TutorialSection)((Change)idChange.getRight()).getOldValue();
            TutorialSection newSection = (TutorialSection)((Change)idChange.getRight()).getNewValue();
            if (jumpedForward) {
                oldStep = (TutorialStep)previousSection.getSteps().getLast();
                newStep = (TutorialStep)newSection.getSteps().getFirst();
            } else {
                oldStep = (TutorialStep)previousSection.getSteps().getFirst();
                newStep = (TutorialStep)newSection.getSteps().getLast();
            }
        }
        return new ImmutableTriple(oldStep, newStep, (Object)jumpedForward);
    }

    private void callSafely(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    private Window getHighlightOwner(Highlight highlight) {
        if (Highlight.isNodeHighlightable((Highlight)highlight)) {
            return ((Node)highlight.getNode().get()).getScene().getWindow();
        }
        return this.gUIStateService.getMainStage();
    }

    private void removeBackdrops() {
        this.highlightPaneMap.forEach((window, pane) -> ((Pane)window.getScene().getRoot()).getChildren().remove(pane));
        this.highlightPaneMap.clear();
    }

    private void updateBackdrop(Highlight highlight) {
        Parent root = this.owner.getScene().getRoot();
        Node highlightNode = null;
        if (highlight != null) {
            if (!highlight.isShowBackdrop()) {
                this.removeUnneededHighlightPanes();
                return;
            }
            if (Highlight.isNodeHighlightable((Highlight)highlight)) {
                highlightNode = (Node)highlight.getNode().get();
                this.scrollNodeIntoView(highlightNode);
            }
        }
        if (this.highlightPaneMap.containsKey(this.owner)) {
            HighlightPane highlightPane = (HighlightPane)this.highlightPaneMap.get(this.owner);
            if (highlight != null && highlight.getTransformation() != null) {
                highlightPane.setHighlightTransformRectangle((Rectangle)highlight.getTransformation().get());
            } else {
                highlightPane.setHighlightTransformRectangle(null);
            }
            highlightPane.updateHighlightedNode(highlightNode);
        } else {
            HighlightPane highlightPane = new HighlightPane((Node)root, highlightNode);
            if (highlight != null && highlight.getTransformation() != null) {
                highlightPane.setHighlightTransformRectangle((Rectangle)highlight.getTransformation().get());
            }
            ((Pane)root.getScene().getRoot()).getChildren().add((Object)highlightPane);
            this.highlightPaneMap.put(this.owner, highlightPane);
            this.addBackdropToParentWindows(this.owner);
        }
        this.removeUnneededHighlightPanes(this.owner);
    }

    private void scrollNodeIntoView(Node highlightNode) {
        Node parent = highlightNode;
        while (parent.getParent() != null && !(parent instanceof ScrollPane)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)parent;
            if (parent != highlightNode) {
                this.fxUiService.centerNodeInScrollPane(scrollPane, highlightNode);
            }
        }
    }

    private void removeUnneededHighlightPanes(Window window) {
        HashSet<Window> neededWindows = new HashSet<Window>();
        neededWindows.add(window);
        while ((window = this.fxUiService.getParentWindow(window)) != null) {
            neededWindows.add(window);
        }
        Map<Window, HighlightPane> toBeRemoved = this.highlightPaneMap.entrySet().stream().filter(entry -> !neededWindows.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        toBeRemoved.forEach((w, pane) -> ((Pane)w.getScene().getRoot()).getChildren().remove(pane));
        this.highlightPaneMap.entrySet().removeAll(toBeRemoved.entrySet());
    }

    private void removeUnneededHighlightPanes() {
        this.highlightPaneMap.forEach((w, pane) -> ((Pane)w.getScene().getRoot()).getChildren().remove(pane));
        this.highlightPaneMap.clear();
    }

    private void addBackdropToParentWindows(Window window) {
        while ((window = this.fxUiService.getParentWindow(window)) != null) {
            HighlightPane parentBackdropPane;
            if (this.highlightPaneMap.containsKey(window)) {
                parentBackdropPane = (HighlightPane)this.highlightPaneMap.get(window);
                parentBackdropPane.updateHighlightedNode(null);
                continue;
            }
            parentBackdropPane = new HighlightPane((Node)window.getScene().getRoot());
            ((Pane)window.getScene().getRoot()).getChildren().add((Object)parentBackdropPane);
            this.highlightPaneMap.put(window, parentBackdropPane);
        }
    }

    @Generated
    public TutorialService(FXUiService fxUiService, ApplicationContext applicationContext, MessageService messageService, FxWeaver fxWeaver, GuiStateService gUIStateService) {
        this.fxUiService = fxUiService;
        this.applicationContext = applicationContext;
        this.messageService = messageService;
        this.fxWeaver = fxWeaver;
        this.gUIStateService = gUIStateService;
    }
}

