/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import ch.qos.logback.classic.Level;
import com.jthemedetecor.util.OsInfo;
import eu.ewerkzeug.easytranscript3.Main;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.scene.text.Font;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final List<Integer> fontSizes = List.of(5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 28, 32, 36, 40, 48, 56, 64, 72);
    private static final List<String> fontFamilies = new ArrayList();
    private static boolean programInitialized = false;

    private Utils() {
    }

    public static double round2Places(double value) {
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static void deleteAllLeftOverTempFiles() {
        Utils.clearTmp((Path)Main.getEasytranscriptTempDirectory());
    }

    public static void clearTmp(Path path) {
        long millis = System.currentTimeMillis();
        try {
            Utils.clearFolder((Path)path);
        }
        catch (IOException e) {
            log.error("Failed to clear path", (Throwable)e);
        }
        log.debug("Finished cleaning. Took {}ms", (Object)(System.currentTimeMillis() - millis));
    }

    public static void clearFolder(Path path) throws IOException {
        log.debug("Clearing folder.");
        if (path != null && path.toFile().exists()) {
            log.debug("Path: {}", (Object)path);
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(file -> {
                    try {
                        Files.delete(file);
                        log.debug("Deleted file {}", file);
                    }
                    catch (IOException e) {
                        log.error("Could not delete file {}.", file, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                log.error("Could not read files.", (Throwable)e);
            }
        } else {
            log.debug("Folder {} does not exist.", path != null ? "null" + String.valueOf(path) : "");
        }
    }

    public static void setLoggingLevel(String level) {
        log.debug("Changing log level to {}...", (Object)level);
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        if (root != null) {
            root.setLevel(Level.toLevel((String)level));
        } else {
            log.warn("Cannot change loglevel since logger is null.");
        }
        log.info("Changed log level to {}", (Object)level);
    }

    public static List<String> getFontFamilies() {
        if (fontFamilies.isEmpty()) {
            List families = Font.getFamilies();
            for (String f : families) {
                List fontNames = Font.getFontNames((String)f);
                boolean boldItalic = false;
                boolean bold = false;
                boolean italic = false;
                for (String fn : fontNames) {
                    if (fn.toLowerCase().endsWith("bold italic")) {
                        boldItalic = true;
                    } else if (fn.toLowerCase().endsWith("italic")) {
                        italic = true;
                    } else if (fn.toLowerCase().endsWith("bold")) {
                        bold = true;
                    }
                    if (!boldItalic || !italic || !bold) continue;
                    break;
                }
                if (!boldItalic || !italic || !bold) continue;
                fontFamilies.add(f);
            }
            log.debug("Fonts installed in system: {}", (Object)fontFamilies);
        }
        return fontFamilies;
    }

    public static String removeControlCharactersFromJSON(String jsonString) {
        return jsonString.replaceAll("[\\x00-\\x1F]", "");
    }

    public static <T> T getFromNonNullableSupplier(@NotNull Supplier<T> supplier) {
        T result = supplier.get();
        if (result == null) {
            log.error("The result of the given non-nullable type supplier is null!");
        }
        return result;
    }

    public static void markAsHidden(Path path) {
        if (OsInfo.isWindows10OrLater()) {
            try {
                DosFileAttributeView fileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
                if (fileAttributeView != null) {
                    fileAttributeView.setHidden(true);
                }
            }
            catch (IOException e) {
                log.error("Could not mark file as hidden", (Throwable)e);
            }
        }
    }

    public static String formatFileSize(long bytes) {
        if (bytes <= 0L) {
            return "0 B";
        }
        if (bytes < 1000L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1000.0));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1000.0, exp), Character.valueOf(pre));
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(46) == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
    }

    public static String getRealHostname() {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            String hostname = osName.contains("win") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
            if (hostname != null && !hostname.isEmpty()) {
                return hostname;
            }
        }
        catch (Exception exception) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception2) {
                return "unknown-host";
            }
        }
        return "unknown-host";
    }

    @Generated
    public static List<Integer> getFontSizes() {
        return fontSizes;
    }

    @Generated
    public static boolean isProgramInitialized() {
        return programInitialized;
    }

    @Generated
    public static void setProgramInitialized(boolean programInitialized) {
        Utils.programInitialized = programInitialized;
    }
}

