/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.util.List;
import java.util.OptionalDouble;
import java.util.function.IntFunction;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.text.Font;
import lombok.Generated;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLineNumberFactory
implements IntFunction<Node> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomLineNumberFactory.class);
    private static final Font DEFAULT_FONT = Font.font((String)"Monospaced", (double)13.0);
    private final Val<Integer> nParagraphs;
    private final IntFunction<String> format;
    private final TranscriptTextArea area;
    private final double defaultFontSize;

    public static IntFunction<Node> get(TranscriptTextArea area, double defaultFontSize) {
        return new CustomLineNumberFactory(LiveList.sizeOf((ObservableList)area.getParagraphs()), digits -> "%1$" + digits + "s", area, defaultFontSize);
    }

    @Override
    public Node apply(int idx) {
        Val formatted = this.nParagraphs.map(n -> this.format(idx + 1, n.intValue()));
        List styledSegments = this.area.getDocument().getParagraph(idx).getStyledSegments();
        OptionalDouble max = styledSegments.stream().mapToDouble(segment -> ((TextStyle)segment.getStyle()).fontSizeOptional.orElse((int)this.defaultFontSize).intValue()).max();
        double fontSize = Math.min(DEFAULT_FONT.getSize(), max.orElse(this.defaultFontSize));
        Font font = Font.font((String)DEFAULT_FONT.getFamily(), (double)fontSize);
        Label lineNo = new Label();
        lineNo.setFont(font);
        lineNo.getStyleClass().add((Object)"lineno");
        int length = (int)(Math.log10(((Integer)this.nParagraphs.getOrElse((Object)1)).intValue()) + 1.0);
        lineNo.setPrefWidth((double)Math.max(30, length * 10));
        if (idx == 0) {
            lineNo.getStyleClass().add((Object)"first-lineno");
        }
        lineNo.textProperty().bind((ObservableValue)formatted.conditionOnShowing((Node)lineNo));
        return lineNo;
    }

    private String format(int x, int max) {
        int digits = (int)Math.floor(Math.log10(max)) + 1;
        return String.format((String)this.format.apply(digits), x);
    }

    @Generated
    public CustomLineNumberFactory(Val<Integer> nParagraphs, IntFunction<String> format, TranscriptTextArea area, double defaultFontSize) {
        this.nParagraphs = nParagraphs;
        this.format = format;
        this.area = area;
        this.defaultFontSize = defaultFontSize;
    }
}

