/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import java.util.HashSet;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.springframework.stereotype.Service;

@Service
public class FXUiService {
    public void centerNodeInScrollPane(ScrollPane scrollPane, Node node) {
        Bounds nodeInScrollPane = scrollPane.getContent().sceneToLocal(node.localToScene(node.getBoundsInLocal()));
        double contentHeight = scrollPane.getContent().getBoundsInLocal().getHeight();
        double nodeCenterY = nodeInScrollPane.getCenterY();
        double viewportHeight = scrollPane.getViewportBounds().getHeight();
        double vValue = (nodeCenterY - 0.5 * viewportHeight) / (contentHeight - viewportHeight);
        vValue = Math.max(0.0, Math.min(1.0, vValue));
        scrollPane.setVvalue(vValue);
        if (vValue == 1.0) {
            scrollPane.setVvalue(scrollPane.getVmax());
        }
    }

    public void runOnePulseLater(Runnable runnable) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public int getGridPaneRowCount(GridPane gridPane) {
        return gridPane.getChildren().stream().mapToInt(n -> {
            Integer row = GridPane.getRowIndex((Node)n);
            Integer rowSpan = GridPane.getRowSpan((Node)n);
            return (row == null ? 0 : row + 1) + (rowSpan == null ? 0 : rowSpan - 1);
        }).max().orElse(0);
    }

    public void deleteRow(GridPane grid, int rowIndex) {
        HashSet<Node> deleteNodes = new HashSet<Node>();
        for (Node child : grid.getChildren()) {
            int r;
            Integer rowI = GridPane.getRowIndex((Node)child);
            int n = r = rowI == null ? 0 : rowI;
            if (r > rowIndex) {
                GridPane.setRowIndex((Node)child, (Integer)(r - 1));
                continue;
            }
            if (r != rowIndex) continue;
            deleteNodes.add(child);
        }
        grid.getChildren().removeAll(deleteNodes);
    }

    public Screen getWindowScreen(Window window) {
        do {
            if (Double.isNaN(window.getX()) || Double.isNaN(window.getY()) || Double.isNaN(window.getWidth()) || Double.isNaN(window.getHeight())) continue;
            return this.getScreenForRectangle(new Rectangle2D(window.getX(), window.getY(), window.getWidth(), window.getHeight()));
        } while ((window = this.getParentWindow(window)) != null);
        return Screen.getPrimary();
    }

    public Window getParentWindow(Window window) {
        Window parentWindow;
        if (window instanceof Stage) {
            Stage stage = (Stage)window;
            parentWindow = stage.getOwner();
        } else if (window instanceof Popup) {
            Popup popup = (Popup)window;
            parentWindow = popup.getOwnerWindow();
        } else {
            parentWindow = null;
        }
        return parentWindow;
    }

    public Screen getScreenForRectangle(Rectangle2D rect) {
        ObservableList screens = Screen.getScreens();
        double rectX0 = rect.getMinX();
        double rectX1 = rect.getMaxX();
        double rectY0 = rect.getMinY();
        double rectY1 = rect.getMaxY();
        Screen selectedScreen = null;
        double maxIntersection = 0.0;
        for (Screen screen : screens) {
            Rectangle2D screenBounds = screen.getBounds();
            double intersection = this.getIntersectionLength(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX()) * this.getIntersectionLength(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY());
            if (!(maxIntersection < intersection)) continue;
            maxIntersection = intersection;
            selectedScreen = screen;
        }
        if (selectedScreen != null) {
            return selectedScreen;
        }
        selectedScreen = Screen.getPrimary();
        double minDistance = Double.MAX_VALUE;
        for (Screen screen : screens) {
            double dy;
            Rectangle2D screenBounds = screen.getBounds();
            double dx = this.getOuterDistance(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX());
            double distance = dx * dx + (dy = this.getOuterDistance(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY())) * dy;
            if (!(minDistance > distance)) continue;
            minDistance = distance;
            selectedScreen = screen;
        }
        return selectedScreen;
    }

    private double getIntersectionLength(double a0, double a1, double b0, double b1) {
        return a0 <= b0 ? this.getIntersectionLengthImpl(b0, b1, a1) : this.getIntersectionLengthImpl(a0, a1, b1);
    }

    private double getIntersectionLengthImpl(double v0, double v1, double v) {
        if (v <= v0) {
            return 0.0;
        }
        return v <= v1 ? v - v0 : v1 - v0;
    }

    private double getOuterDistance(double a0, double a1, double b0, double b1) {
        if (a1 <= b0) {
            return b0 - a1;
        }
        if (b1 <= a0) {
            return b1 - a0;
        }
        return 0.0;
    }
}

