/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.commons.fx.GeometryUtils;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlightPane
extends Pane {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HighlightPane.class);
    private static final String DEFAULT_CLASS_NAME = "highlighted-pane";
    private final BooleanProperty backdropMouseTransparent = new SimpleBooleanProperty(false);
    private final BooleanProperty closeOnBackdropClick = new SimpleBooleanProperty(false);
    private final ObjectProperty<Rectangle> highlightTransformRectangle = new SimpleObjectProperty();
    private final Rectangle highlightRect = new Rectangle();
    private final Path backdropShape = new Path();
    private Node highlightedNode;
    private Node rootNode;
    private final ChangeListener<Bounds> nodeBoundsChangeListener = (observable, oldValue, newValue) -> this.updateHighlightAndBackdrop();
    private final ChangeListener<Number> rootNodeBoundsChangeListener = (observable, oldValue, newValue) -> this.updateHighlightAndBackdrop();

    public HighlightPane() {
        this.getStyleClass().add((Object)DEFAULT_CLASS_NAME);
        this.setPickOnBounds(false);
        this.highlightTransformRectangle.addListener((observable, oldValue, newValue) -> this.updateHighlightedNode(this.highlightedNode));
    }

    public HighlightPane(Node rootNode) {
        this();
        this.setRootNode(rootNode);
        this.initBackdropShape();
    }

    public HighlightPane(Node rootNode, Node highlightedNode) {
        this();
        this.setRootNode(rootNode);
        this.setHighlightedNode(highlightedNode);
        this.initBackdropShape();
    }

    private void updateHighlightAndBackdrop() {
        Platform.runLater(() -> {
            GeometryUtils.setRectangleTo((Rectangle)this.highlightRect, (Rectangle)GeometryUtils.getShapeOnScreen((Node)this.highlightedNode, (Rectangle)this.getHighlightTransformation()));
            this.updateBackdropShape();
        });
    }

    public void updateRootNode(Node rootNode) {
        this.removeBackdropShape();
        this.setRootNode(rootNode);
        this.initBackdropShape();
    }

    public void updateHighlightedNode(Node highlightedNode) {
        this.removeHighlightRect();
        this.setHighlightedNode(highlightedNode);
        this.initBackdropShape();
    }

    public void show() {
        this.setManaged(true);
        this.setVisible(true);
    }

    public void hide() {
        this.setManaged(false);
        this.setVisible(false);
    }

    public boolean getBackdropMouseTransparent() {
        return this.backdropMouseTransparent.get();
    }

    public void setBackdropMouseTransparent(boolean backdropMouseTransparent) {
        this.backdropMouseTransparent.set(backdropMouseTransparent);
    }

    public BooleanProperty backdropMouseTransparentProperty() {
        return this.backdropMouseTransparent;
    }

    public Rectangle getHighlightTransformation() {
        return (Rectangle)this.highlightTransformRectangle.get();
    }

    public void setHighlightTransformRectangle(Rectangle rectangle) {
        this.highlightTransformRectangle.set((Object)rectangle);
    }

    public ObjectProperty<Rectangle> highlightTransformRectangleProperty() {
        return this.highlightTransformRectangle;
    }

    public boolean isCloseOnBackdropClick() {
        return this.closeOnBackdropClick.get();
    }

    public void setCloseOnBackdropClick(boolean closeOnBackdropClick) {
        this.closeOnBackdropClick.set(closeOnBackdropClick);
    }

    public BooleanProperty closeOnBackdropClickProperty() {
        return this.closeOnBackdropClick;
    }

    private void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
        if (this.rootNode != null) {
            this.rootNode.getScene().getWindow().widthProperty().addListener(this.rootNodeBoundsChangeListener);
            this.rootNode.getScene().getWindow().heightProperty().addListener(this.rootNodeBoundsChangeListener);
        }
    }

    private void setHighlightedNode(Node highlightedNode) {
        this.highlightedNode = highlightedNode;
        this.initHighlightRect(highlightedNode);
        if (highlightedNode != null) {
            highlightedNode.boundsInParentProperty().addListener(this.nodeBoundsChangeListener);
            ScrollPane scrollPaneParent = this.findScrollPaneParent(highlightedNode);
            if (scrollPaneParent != null) {
                scrollPaneParent.vvalueProperty().addListener(change -> this.updateHighlightAndBackdrop());
            }
            this.getChildren().add((Object)this.highlightRect);
        }
    }

    private ScrollPane findScrollPaneParent(Node node) {
        Node parent = node;
        while (parent.getParent() != null && !(parent instanceof ScrollPane)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)parent;
            return scrollPane;
        }
        return null;
    }

    private void removeHighlightRect() {
        if (this.highlightedNode != null) {
            this.highlightedNode.boundsInParentProperty().removeListener(this.nodeBoundsChangeListener);
            this.getChildren().remove((Object)this.highlightRect);
        }
    }

    private void removeBackdropShape() {
        if (this.rootNode != null) {
            this.rootNode.getScene().getWindow().widthProperty().removeListener(this.rootNodeBoundsChangeListener);
            this.rootNode.getScene().getWindow().heightProperty().removeListener(this.rootNodeBoundsChangeListener);
            this.getChildren().remove((Object)this.backdropShape);
        }
    }

    private void initBackdropShape() {
        this.getChildren().remove((Object)this.backdropShape);
        this.updateBackdropShape();
        this.backdropShape.mouseTransparentProperty().bind((ObservableValue)this.backdropMouseTransparent);
        this.backdropShape.getStyleClass().add((Object)"highlight-backdrop");
        this.backdropShape.setStroke((Paint)Color.TRANSPARENT);
        this.backdropShape.setOnMouseClicked(event -> {
            if (this.closeOnBackdropClick.get()) {
                this.hide();
            }
        });
        this.getChildren().add((Object)this.backdropShape);
    }

    private void updateBackdropShape() {
        this.backdropShape.getElements().setAll((Collection)GeometryUtils.getInverseClip((Shape)GeometryUtils.getShapeOnScreen((Node)this.highlightedNode, (Rectangle)this.getHighlightTransformation()), (Shape)GeometryUtils.getShapeOnScreen((Node)this.rootNode)).getElements());
    }

    private void initHighlightRect(Node highlightedNode) {
        GeometryUtils.setRectangleTo((Rectangle)this.highlightRect, (Rectangle)GeometryUtils.getShapeOnScreen((Node)highlightedNode, (Rectangle)this.getHighlightTransformation()));
        this.highlightRect.setManaged(false);
        this.highlightRect.setFill((Paint)Color.TRANSPARENT);
        this.highlightRect.setMouseTransparent(true);
        this.highlightRect.setPickOnBounds(false);
        this.highlightRect.getStyleClass().add((Object)"highlight-border");
    }
}

