/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.commons.fx.Position;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import lombok.Generated;
import org.jetbrains.annotations.Contract;

public final class Placement {
    private final double windowWidth;
    private final double windowHeight;
    private final Bounds toAlignTo;
    private final int horizontalDistance;
    private final int verticalDistance;
    private final Rectangle2D screenBounds;

    public Placement(double windowWidth, double windowHeight, Rectangle2D screenBounds, Bounds toAlignTo, int horizontalDistance, int verticalDistance) {
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.screenBounds = screenBounds;
        this.toAlignTo = toAlignTo;
        this.horizontalDistance = horizontalDistance;
        this.verticalDistance = verticalDistance;
    }

    public double insideRight() {
        return this.toAlignTo.getMaxX() - this.windowWidth + (double)this.horizontalDistance;
    }

    public double insideLeft() {
        return this.toAlignTo.getMinX() + (double)this.horizontalDistance;
    }

    public double toTheLeft() {
        return this.insideLeft() - this.windowWidth;
    }

    public double toTheRight() {
        return this.insideRight() + this.windowWidth;
    }

    public double insideBottom() {
        return this.toAlignTo.getMaxY() - this.windowHeight;
    }

    public double insideTop() {
        return this.toAlignTo.getMinY();
    }

    public double above() {
        return this.insideTop() - this.windowHeight;
    }

    public double below() {
        return this.insideBottom() + this.windowHeight;
    }

    @Contract(pure=true)
    public Position getHorizontalOverlap(Double position) {
        Position horizontal = null;
        if (position + this.windowWidth > this.screenBounds.getMaxX()) {
            horizontal = Position.RIGHT;
        } else if (position < this.screenBounds.getMinX()) {
            horizontal = Position.LEFT;
        }
        return horizontal;
    }

    @Contract(pure=true)
    public Position getVerticalOverlap(Double position) {
        Position vertical = null;
        if (position + this.windowHeight > this.screenBounds.getMaxY()) {
            vertical = Position.BOTTOM;
        } else if (position < this.screenBounds.getMinY()) {
            vertical = Position.TOP;
        }
        return vertical;
    }

    @Generated
    public double getWindowWidth() {
        return this.windowWidth;
    }

    @Generated
    public double getWindowHeight() {
        return this.windowHeight;
    }

    @Generated
    public Bounds getToAlignTo() {
        return this.toAlignTo;
    }

    @Generated
    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    @Generated
    public int getVerticalDistance() {
        return this.verticalDistance;
    }
}

