/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.ShowSpeakerPopupEvent;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javafx.scene.control.IndexRange;
import lombok.Generated;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.jspecify.annotations.NonNull;
import org.reactfx.collection.LiveList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class SpeakerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerService.class);
    private final TranscriptTextArea transcriptTextArea;
    private final ApplicationEventPublisher eventPublisher;
    private final TranscriptService transcriptService;

    public void replaceSpeakerWithText(Speaker speaker) {
        boolean hasChanges = false;
        MultiChangeBuilder multiChange = this.transcriptTextArea.createMultiChange();
        LiveList paragraphs = this.transcriptTextArea.getParagraphs();
        int pos = 0;
        for (Paragraph p : paragraphs) {
            List styledSegments = p.getStyledSegments();
            if (styledSegments.stream().anyMatch(f -> f.getSegment() instanceof SpeakerSegment)) {
                for (StyledSegment s : styledSegments) {
                    pos += ((AbstractSegment)s.getSegment()).length();
                    if (!(s.getSegment() instanceof SpeakerSegment) || !((SpeakerSegment)s.getSegment()).getUuid().equals(speaker.getUuid().toString())) continue;
                    multiChange.replaceText(pos - 1, pos, ((AbstractSegment)s.getSegment()).getRealText());
                    hasChanges = true;
                }
            } else {
                pos += p.length();
            }
            ++pos;
        }
        if (hasChanges) {
            this.transcriptTextArea.commitMultiChange(multiChange);
        }
    }

    public void updateSpeaker(Speaker speaker) {
        log.debug("Updating speaker with uuid {}", (Object)speaker.getUuid());
        this.updateSpeakers(List.of(speaker));
    }

    public void updateSpeakerSegmentStyle() {
        log.debug("Updating style of speaker segments ...");
        this.transcriptTextArea.getParagraphs().stream().flatMap(paragraph -> paragraph.getStyledSegments().stream()).map(StyledSegment::getSegment).filter(SpeakerSegment.class::isInstance).map(SpeakerSegment.class::cast).forEach(segment -> segment.updateStyle(this.transcriptService.getCurrentTranscript().getSpeakerTextStyle()));
    }

    public void updateSpeakers(List<Speaker> speakers) {
        HashMap speakerMap = new HashMap();
        speakers.forEach(f -> speakerMap.put(f.getUuid().toString(), f));
        boolean hasChanges = false;
        MultiChangeBuilder multiChange = this.transcriptTextArea.createMultiChange();
        LiveList paragraphs = this.transcriptTextArea.getParagraphs();
        int pos = 0;
        for (Paragraph p : paragraphs) {
            List styledSegments = p.getStyledSegments();
            if (styledSegments.stream().anyMatch(f -> f.getSegment() instanceof SpeakerSegment)) {
                for (StyledSegment s : styledSegments) {
                    Speaker speaker;
                    pos += ((AbstractSegment)s.getSegment()).length();
                    if (!(s.getSegment() instanceof SpeakerSegment) || (speaker = (Speaker)speakerMap.get(((SpeakerSegment)s.getSegment()).getUuid())) == null) continue;
                    multiChange.deleteText(pos - 1, pos);
                    multiChange.insert(pos, (StyledDocument)this.getSpeakerDoc(speaker));
                    hasChanges = true;
                }
            } else {
                pos += p.length();
            }
            ++pos;
        }
        if (hasChanges) {
            this.transcriptTextArea.commitMultiChange(multiChange);
        }
    }

    public void insertSpeaker(Speaker speaker) {
        this.insertSpeaker(speaker, true);
    }

    public void insertSpeaker(Speaker speaker, boolean showSpeakerPopup) {
        log.debug("Inserting Speaker {} at pos {} ", (Object)speaker.getUuid(), (Object)this.transcriptTextArea.getCaretPosition());
        ReadOnlyStyledDocument speakerDoc = this.getSpeakerDoc(speaker);
        IndexRange selection = this.transcriptTextArea.getSelection();
        this.transcriptTextArea.replace(selection.getStart(), selection.getEnd(), (StyledDocument)speakerDoc);
        this.transcriptTextArea.deselect();
        if (showSpeakerPopup) {
            SpeakerSegment speakerSegment = (SpeakerSegment)((Paragraph)speakerDoc.getParagraphs().getFirst()).getSegments().getFirst();
            this.eventPublisher.publishEvent((Object)new ShowSpeakerPopupEvent(speakerSegment, (List)this.getSpeakerList(speaker)));
        }
    }

    public void showSpeakerPopup(SpeakerSegment speakerSegment) {
        Speaker speaker = this.findSpeaker(speakerSegment);
        ArrayList list = this.getSpeakerList(speaker);
        if (list.size() > 1) {
            this.eventPublisher.publishEvent((Object)new ShowSpeakerPopupEvent(speakerSegment, (List)list));
        }
    }

    private @NonNull ArrayList<Speaker> getSpeakerList(Speaker speaker) {
        if (speaker == null) {
            log.warn("Did not find any speaker for segment");
            speaker = (Speaker)this.transcriptService.getCurrentTranscript().getSpeakers().getFirst();
        }
        ArrayList<Speaker> list = new ArrayList<Speaker>();
        int startIndex = this.transcriptService.getCurrentTranscript().getSpeakers().indexOf(speaker);
        while (list.size() < this.transcriptService.getCurrentTranscript().getSpeakers().size()) {
            list.add((Speaker)this.transcriptService.getCurrentTranscript().getSpeakers().get(startIndex));
            startIndex = (startIndex + 1) % this.transcriptService.getCurrentTranscript().getSpeakers().size();
        }
        return list;
    }

    private Speaker findSpeaker(SpeakerSegment speakerSegment) {
        Optional<Speaker> first = this.transcriptService.getCurrentTranscript().getSpeakers().stream().filter(f -> f.getUuid().toString().equals(speakerSegment.getUuid())).findFirst();
        return first.orElse(null);
    }

    public ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> getSpeakerDoc(Speaker speaker) {
        SpeakerSegment seg = this.createSegment(speaker.getUuid());
        return ReadOnlyStyledDocument.fromSegment((Object)seg, (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    public SpeakerSegment createSegment(UUID uuid) {
        String name = this.findSpeakerName(uuid);
        TextStyle style = this.transcriptService.getCurrentTranscript().getSpeakerTextStyle();
        return new SpeakerSegment((Object)uuid, name, style);
    }

    private String findSpeakerName(UUID uuid) {
        return this.transcriptService.getCurrentTranscript().getSpeakers().stream().filter(s -> s.getUuid().equals(uuid)).map(Speaker::getName).findFirst().orElse("Unknown");
    }

    public void refreshSegment(SpeakerSegment segment) {
        UUID uuid = UUID.fromString(segment.getUuid());
        String currentName = this.findSpeakerName(uuid);
        TextStyle currentStyle = this.transcriptService.getCurrentTranscript().getSpeakerTextStyle();
        if (segment.getItem() != null) {
            segment.getItem().setText(currentName);
            segment.updateStyle(currentStyle);
        }
    }

    @Generated
    public SpeakerService(TranscriptTextArea transcriptTextArea, ApplicationEventPublisher eventPublisher, TranscriptService transcriptService) {
        this.transcriptTextArea = transcriptTextArea;
        this.eventPublisher = eventPublisher;
        this.transcriptService = transcriptService;
    }
}

