/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.ThemeService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.net.URISyntaxException;
import java.util.TimeZone;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimestampService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimestampService.class);
    private final TranscriptTextArea textArea;
    private final ConfigurationService configurationService;
    private final ThemeService themeService;
    private final TranscriptService transcriptService;

    public void insertTimestamp() {
        if (this.transcriptService.getCurrentTranscript().getMediaLocation() != null && Main.getPlayer() != null && Main.getPlayer().isMediaLoaded() && Main.getPlayer().isPlayerReady()) {
            long currentMillis = Main.getPlayer().getTime();
            this.insertTimestamp(currentMillis);
            this.textArea.requestFollowCaret();
        }
    }

    public void insertTimestamp(long currentMillis) {
        currentMillis = Math.max(0L, currentMillis + this.configurationService.getConfiguration().getTimestampOffset());
        IndexRange selection = this.textArea.getSelection();
        log.debug("Inserting timestamp at pos {} and time {}", (Object)selection.getEnd(), (Object)currentMillis);
        ReadOnlyStyledDocument timestampDoc = this.getTimestampDoc(currentMillis);
        this.textArea.replaceWithoutMovingCaret(selection.getStart(), selection.getEnd(), (StyledDocument)timestampDoc);
        this.textArea.deselect();
    }

    public ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> getTimestampDoc(long currentMillis) {
        try {
            return ReadOnlyStyledDocument.fromSegment((Object)this.createSegment(currentMillis), (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public TimestampSegment createSegment(long millis) throws URISyntaxException {
        String format = this.configurationService.getConfiguration().getTimestampsFormat();
        String text = this.formatMillis(millis, format);
        return new TimestampSegment((Object)millis, text, this.getTimestampStyle());
    }

    public void updateSegmentFormat(TimestampSegment segment) {
        String format = this.configurationService.getConfiguration().getTimestampsFormat();
        String text = this.formatMillis(segment.getMillis(), format);
        segment.getItem().setText(text);
    }

    public String formatMillis(long millis, String format) {
        return DateFormatUtils.format((long)millis, (String)format, (TimeZone)TimeZone.getTimeZone("GMT"));
    }

    public TextStyle getTimestampStyle() throws URISyntaxException {
        Color color = (Color)this.themeService.getCssVariable("-fx-highlight-timestamp");
        return new TextStyle().updateTextColor(color).updateFontFamily("Monospaced").updateFontSize(10);
    }

    @Generated
    public TimestampService(TranscriptTextArea textArea, ConfigurationService configurationService, ThemeService themeService, TranscriptService transcriptService) {
        this.textArea = textArea;
        this.configurationService = configurationService;
        this.themeService = themeService;
        this.transcriptService = transcriptService;
    }
}

