/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import com.jthemedetecor.util.OsInfo;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import org.apache.commons.lang3.tuple.MutablePair;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WindowManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowManagerService.class);
    public static final String ET_IDENTIFIER = "/climbingperch/easytranscript";
    public static final String MAIN_WINDOW_IDENTIFIER = "/climbingperch/easytranscript/main";
    private static final String WINDOW_POSITION_X = "window_position_x";
    private static final String WINDOW_POSITION_Y = "window_position_y";
    private static final String WINDOW_WIDTH = "window_width";
    private static final String WINDOW_HEIGHT = "window_height";
    private static final String WINDOW_MAXIMIZED = "window_maximized";

    public Screen getScreenWithBiggestOverlap(Window window) {
        ObservableList screensForRectangle = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)window.getWidth(), (double)window.getHeight());
        MutablePair screenWithBiggestOverlap = new MutablePair((Object)0.0, (Object)Screen.getPrimary());
        for (Screen s : screensForRectangle) {
            Rectangle2D screenRect2d = s.getBounds();
            Rectangle screenRect = new Rectangle(screenRect2d.getMinX(), screenRect2d.getMinY(), screenRect2d.getWidth(), screenRect2d.getHeight());
            Rectangle windowRect = new Rectangle(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            Path subtract = (Path)Shape.intersect((Shape)screenRect, (Shape)windowRect);
            double horizontalOverlap = subtract.getBoundsInLocal().getWidth();
            if (!((Double)screenWithBiggestOverlap.getKey() < horizontalOverlap)) continue;
            screenWithBiggestOverlap.setLeft((Object)horizontalOverlap);
            screenWithBiggestOverlap.setRight((Object)s);
        }
        return (Screen)screenWithBiggestOverlap.getValue();
    }

    public Optional<Window> findOpenWindowByController(Class<? extends ExtendedController> controllerClass) {
        return Window.getWindows().stream().filter(window -> window.getUserData() != null && window.getUserData().equals(controllerClass.getName())).findFirst();
    }

    public void addIconsToStage(Stage stage, boolean dark) {
        String folder = !dark ? "dark" : "light";
        Platform.runLater(() -> {
            stage.getIcons().clear();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(WindowManagerService.class.getResourceAsStream("/images/" + folder + "/favicon_16.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(WindowManagerService.class.getResourceAsStream("/images/" + folder + "/favicon_32.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(WindowManagerService.class.getResourceAsStream("/images/" + folder + "/favicon_64.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(WindowManagerService.class.getResourceAsStream("/images/" + folder + "/favicon_96.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(WindowManagerService.class.getResourceAsStream("/images/" + folder + "/favicon_512.png"))));
        });
    }

    public void storeSizeAndPosition(Window window, BoundingBox beforeMaximizing, String identifier) throws BackingStoreException {
        double height;
        double width;
        double y;
        double x;
        log.debug("Storing size and position for window with identifier {} ...", (Object)identifier);
        Preferences preferences = Preferences.userRoot().node(identifier);
        if (beforeMaximizing != null) {
            log.debug("Found before maximizing data...");
            x = beforeMaximizing.getMinX();
            y = beforeMaximizing.getMinY();
            width = beforeMaximizing.getWidth();
            height = beforeMaximizing.getHeight();
        } else {
            x = window.getX();
            y = window.getY();
            width = window.getWidth();
            height = window.getHeight();
        }
        preferences.putDouble(WINDOW_POSITION_X, x);
        preferences.putDouble(WINDOW_POSITION_Y, y);
        preferences.putDouble(WINDOW_WIDTH, width);
        preferences.putDouble(WINDOW_HEIGHT, height);
        preferences.putBoolean(WINDOW_MAXIMIZED, ((Stage)window).isMaximized());
        preferences.flush();
        log.debug("Stored Position and size: {},{},{},{} - {}", new Object[]{x, y, width, height, ((Stage)window).isMaximized()});
    }

    public boolean hasStoredSizeAndPosition(String identifier) {
        try {
            return Preferences.userRoot().nodeExists(identifier);
        }
        catch (BackingStoreException e) {
            log.error("Could not check if there are sizes and positions stored.", (Throwable)e);
            return false;
        }
    }

    public void setSizeAndPosition(Window window, String identifier) {
        Preferences pref = Preferences.userRoot().node(identifier);
        log.debug("Setting stored size and position for window with identifier {}: {}...", (Object)identifier, (Object)pref.toString());
        double x = pref.getDouble(WINDOW_POSITION_X, window.getX());
        double y = pref.getDouble(WINDOW_POSITION_Y, window.getY());
        double width = pref.getDouble(WINDOW_WIDTH, window.getWidth());
        double height = pref.getDouble(WINDOW_HEIGHT, window.getHeight());
        boolean maximized = pref.getBoolean(WINDOW_MAXIMIZED, ((Stage)window).isMaximized());
        log.debug("Restoring Position and size: {},{},{},{} - {}", new Object[]{x, y, width, height, maximized});
        window.setX(x);
        window.setY(y);
        window.setWidth(width);
        window.setHeight(height);
        Screen screen = this.getScreenWithBiggestOverlap(window);
        Rectangle2D bounds = screen.getVisualBounds();
        x = x + width > bounds.getMaxX() ? bounds.getMaxX() - width : x;
        y = y + height > bounds.getMaxY() ? bounds.getMaxY() - height : y;
        x = Math.max(bounds.getMinX(), x);
        y = Math.max(bounds.getMinY(), y);
        width = Math.min(bounds.getWidth(), width);
        height = Math.min(bounds.getHeight(), height);
        window.setX(x);
        window.setY(y);
        window.setWidth(width);
        window.setHeight(height);
        window.getProperties().put((Object)"beforeMaximizingHeight", (Object)height);
        window.getProperties().put((Object)"beforeMaximizingWidth", (Object)width);
        window.getProperties().put((Object)"beforeMaximizingX", (Object)x);
        window.getProperties().put((Object)"beforeMaximizingY", (Object)y);
        if (!OsInfo.isMacOsMojaveOrLater()) {
            FxTimer.runLater((Duration)Duration.of(500L, ChronoUnit.MILLIS), () -> ((Stage)window).setMaximized(maximized));
        }
    }

    @Generated
    public WindowManagerService() {
    }
}

