/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.alerts;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.ThemeService;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxWeaver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class DialogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DialogService.class);
    private final FxWeaver fxWeaver;
    private final ThemeService themeService;
    private final MessageService messageService;
    private final GuiStateService guiStateService;

    public ETDialog createDialog(String title, String text, Modality modality, List<ETButtonType> buttons, Window owner) {
        log.debug("Creating dialog...");
        FxControllerAndView view = this.fxWeaver.load(ETDialog.class, this.messageService.getLocaleBundle());
        ETDialog etDialog = (ETDialog)view.getController();
        Node node = (Node)view.getView().orElseThrow(() -> new RuntimeException("Could not load view for ETDialog"));
        Scene scene = new Scene((Parent)node);
        this.themeService.setStyleSheets(scene);
        Stage stage = new Stage();
        stage.initStyle(StageStyle.UTILITY);
        stage.setResizable(false);
        stage.setScene(scene);
        etDialog.setStage(stage);
        if (buttons != null) {
            etDialog.setButtons(buttons);
        } else {
            ArrayList<ETButtonType> buttonTypeList = new ArrayList<ETButtonType>();
            buttonTypeList.add(new ETButtonType(new ButtonType(ButtonType.OK.getText(), ButtonBar.ButtonData.OK_DONE), true, false));
            etDialog.setButtons(buttonTypeList);
        }
        etDialog.getOtherContent().setManaged(false);
        etDialog.getOtherContent().getChildren().addListener(change -> etDialog.getOtherContent().setManaged(!etDialog.getOtherContent().getChildren().isEmpty()));
        if (owner != null) {
            stage.initOwner(owner);
        } else if (this.guiStateService.getMainStage() != null) {
            stage.initOwner((Window)this.guiStateService.getMainStage());
        }
        etDialog.setText(text);
        etDialog.setTitle(title);
        etDialog.initModality(modality);
        log.debug("Dialog created.");
        return etDialog;
    }

    public ETDialog createDialog(String title, String text, Modality modality, List<ETButtonType> buttons) {
        return this.createDialog(title, text, modality, buttons, (Window)this.guiStateService.getMainStage());
    }

    public ETDialog get(String text) {
        return this.get("", text);
    }

    public ETDialog get(String text, Alert.AlertType type) {
        return this.get("", text);
    }

    public ETDialog get(String title, String text) {
        return this.createDialog(title, text, Modality.WINDOW_MODAL, null);
    }

    public ETDialog get(String title, String text, Window owner) {
        return this.createDialog(title, text, Modality.WINDOW_MODAL, null, owner);
    }

    @Generated
    public DialogService(FxWeaver fxWeaver, ThemeService themeService, MessageService messageService, GuiStateService guiStateService) {
        this.fxWeaver = fxWeaver;
        this.themeService = themeService;
        this.messageService = messageService;
        this.guiStateService = guiStateService;
    }
}

