/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.alerts;

import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@FxmlView(value="etDialog.fxml")
public class ETDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETDialog.class);
    ETButtonType selectedButtonType;
    @FXML
    private VBox root;
    @FXML
    private Label text;
    @FXML
    private ButtonBar buttonBar;
    @FXML
    private VBox otherContent;
    private Stage stage;

    protected Button createButton(ETButtonType buttonType) {
        Button button = new Button(buttonType.getButtonType().getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonType().getButtonData();
        ButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
        button.setDefaultButton(buttonData.isDefaultButton());
        if (buttonType.isDefaultButton()) {
            button.getStyleClass().add((Object)"primary-button");
        } else {
            button.getStyleClass().add((Object)"secondary-button");
        }
        button.setCancelButton(buttonType.isCancelButton());
        return button;
    }

    public void setText(String content) {
        this.text.setText(content);
    }

    public void setButtons(List<ETButtonType> buttons) {
        this.buttonBar.getButtons().clear();
        buttons.forEach(b -> {
            Button button = this.createButton(b);
            button.setOnAction(actionEvent -> {
                this.selectedButtonType = b;
                this.stage.close();
            });
            this.buttonBar.getButtons().add((Object)button);
        });
    }

    public ButtonType showAndWait() {
        this.selectedButtonType = null;
        this.stage.centerOnScreen();
        this.stage.showAndWait();
        return this.selectedButtonType == null ? null : this.selectedButtonType.getButtonType();
    }

    public void initModality(Modality modality) {
        ((Stage)this.text.getScene().getWindow()).initModality(modality);
    }

    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    @Generated
    public VBox getOtherContent() {
        return this.otherContent;
    }

    @Generated
    public Stage getStage() {
        return this.stage;
    }

    @Generated
    public void setStage(Stage stage) {
        this.stage = stage;
    }
}

