/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.alerts;

import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.commons.LogUploadService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class ExceptionAlert {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionAlert.class);
    private final TextField mailTextField = new JFXTextField();
    private final DialogService dialogService;
    private final TextArea textArea = new JFXTextArea();
    private final TextArea exceptionTextArea = new JFXTextArea();
    private final ConfigurationService configurationService;
    private final LicenseService licenseService;
    private final LogUploadService logUploadService;
    private final MessageService messageService;
    private ResourceBundle messages;
    private ETButtonType send;
    private ETButtonType dontSend;
    private ETDialog alert;

    @PostConstruct
    public void init() {
        this.messages = this.messageService.getLocaleBundle();
        this.send = new ETButtonType(new ButtonType(this.messages.getString("exceptionAlert.SendReport"), ButtonBar.ButtonData.YES), true, false);
        this.dontSend = new ETButtonType(new ButtonType(this.messages.getString("exceptionAlert.DontSendReport"), ButtonBar.ButtonData.NO), false, false);
    }

    private void initAlert(String message) {
        log.debug("Initializing exception alert...");
        if (this.alert == null) {
            log.debug("Creating alert...");
            this.alert = this.dialogService.get(this.messages.getString("exceptionAlert.Title"), "");
            this.alert.getStage().initModality(Modality.APPLICATION_MODAL);
            this.alert.getStage().setAlwaysOnTop(true);
            this.alert.getStage().initOwner(null);
            this.alert.setButtons(List.of(this.dontSend, this.send));
            this.exceptionTextArea.setEditable(false);
            this.exceptionTextArea.setWrapText(true);
            this.exceptionTextArea.setMaxWidth(Double.MAX_VALUE);
            this.exceptionTextArea.setMaxHeight(Double.MAX_VALUE);
            this.exceptionTextArea.getStyleClass().add((Object)"exception-dialog-text");
            this.mailTextField.getStyleClass().add((Object)"exception-dialog-text");
            this.alert.getStage().setWidth(600.0);
            VBox vbox = new VBox();
            TextFlow textFlow = new TextFlow();
            Label mail = new Label(this.messages.getString("exceptionAlert.Mail"));
            mail.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
            Label error = new Label(this.messageService.getLocaleBundle().getString("exceptionAlert.MailNotValid"));
            error.setVisible(false);
            error.setTextFill(Paint.valueOf((String)"red"));
            textFlow.getChildren().addAll((Object[])new Node[]{mail, error});
            VBox.setMargin((Node)this.textArea, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
            this.textArea.getStyleClass().add((Object)"exception-dialog-text");
            Label label = new Label(this.messageService.getLocaleBundle().getString("problems.errorSituationDescription"));
            VBox.setMargin((Node)label, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
            Accordion accordion = new Accordion();
            TitledPane titledPane = new TitledPane();
            titledPane.setText(this.messages.getString("exceptionAlert.Report"));
            titledPane.setExpanded(false);
            titledPane.setContent((Node)this.exceptionTextArea);
            accordion.getPanes().add((Object)titledPane);
            vbox.getChildren().addAll((Object[])new Node[]{textFlow, this.mailTextField, label, this.textArea, accordion});
            vbox.setFillWidth(true);
            this.alert.getOtherContent().getChildren().add((Object)vbox);
            titledPane.expandedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.equals(oldValue) && newValue.booleanValue()) {
                    this.exceptionTextArea.setScrollTop(Double.MAX_VALUE);
                }
            });
        }
        this.alert.setText(message);
        this.mailTextField.clear();
        this.textArea.clear();
        StringBuilder sb = new StringBuilder();
        int[] counter = new int[]{0};
        int nLines = 200;
        log.debug("Reading last {} lines of active log file.", (Object)nLines);
        Path path = Path.of(Configuration.ET_HOME + "/logs/easytranscript.log", new String[0]);
        try (Stream<String> stream = Files.lines(path);){
            List<String> collect = stream.toList();
            int length = collect.size();
            collect.forEach(f -> {
                if (length - counter[0] <= nLines) {
                    sb.append((String)f).append("\n");
                }
                counter[0] = counter[0] + 1;
            });
        }
        catch (IOException e) {
            log.error("There was an error reading the log file.", (Throwable)e);
        }
        log.debug("Adding the log lines to the exception alert.");
        this.exceptionTextArea.setText(sb.toString());
        log.debug("Exception alert initialized.");
    }

    private void handle(ButtonType buttonType) {
        log.debug("Button type: {}", (Object)buttonType);
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        if (buttonType != null && buttonType.equals(this.send.getButtonType())) {
            log.debug("User clicked send button. Preparing upload...");
            CompletableFuture.runAsync((Runnable)task);
        }
    }

    private String getLicensedUser(UserLicense userLicense) {
        if (userLicense == null) {
            return "none";
        }
        if (userLicense.getUsername() != null) {
            return userLicense.getUsername();
        }
        return userLicense.getDisplayName();
    }

    public void showModal() {
        this.showModal(false);
    }

    public void showModal(boolean userInitiated) {
        log.debug("Showing exception alert.");
        Platform.runLater(() -> {
            this.initAlert(userInitiated ? this.messages.getString("exceptionAlert.MessageUserInitiated") : this.messages.getString("exceptionAlert.Message"));
            if (!this.alert.getStage().isShowing()) {
                ButtonType buttonType = this.alert.showAndWait();
                this.handle(buttonType);
            } else {
                this.alert.getStage().toFront();
                this.alert.getStage().requestFocus();
            }
        });
    }

    @Generated
    public ExceptionAlert(DialogService dialogService, ConfigurationService configurationService, LicenseService licenseService, LogUploadService logUploadService, MessageService messageService) {
        this.dialogService = dialogService;
        this.configurationService = configurationService;
        this.licenseService = licenseService;
        this.logUploadService = logUploadService;
        this.messageService = messageService;
    }
}

