/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.CustomButtonBarSkin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.skin.ButtonBarSkin;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class CustomButtonBarSkin
extends ButtonBarSkin {
    private static final double GAP_SIZE = 4.0;
    private static final String CATEGORIZED_TYPES = "LRHEYNXBIACO";
    private static final double DO_NOT_CHANGE_SIZE = Double.MAX_VALUE;
    private final HBox layout;
    private final InvalidationListener buttonDataListener = o -> this.layoutButtons();

    public CustomButtonBarSkin(ButtonBar control) {
        super(control);
        this.layout = new /* Unavailable Anonymous Inner Class!! */;
        this.layout.setAlignment(Pos.CENTER_RIGHT);
        this.layout.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.layout);
        this.layoutButtons();
        this.updateButtonListeners((List)control.getButtons(), true);
        control.getButtons().addListener(c -> {
            while (c.next()) {
                this.updateButtonListeners(c.getRemoved(), false);
                this.updateButtonListeners(c.getAddedSubList(), true);
            }
            this.layoutButtons();
        });
        this.registerChangeListener((ObservableValue)control.buttonOrderProperty(), e -> this.layoutButtons());
    }

    private void updateButtonListeners(List<? extends Node> list, boolean buttonsAdded) {
        if (list != null) {
            for (Node node : list) {
                ObjectProperty property;
                ObservableMap properties = node.getProperties();
                if (!properties.containsKey("javafx.scene.control.ButtonBar.ButtonData") || (property = (ObjectProperty)properties.get("javafx.scene.control.ButtonBar.ButtonData")) == null) continue;
                if (buttonsAdded) {
                    property.addListener(this.buttonDataListener);
                    continue;
                }
                property.removeListener(this.buttonDataListener);
            }
        }
    }

    private void layoutButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        ObservableList buttons = buttonBar.getButtons();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        buttons.forEach(b -> ButtonBar.setButtonUniformSize((Node)b, (boolean)false));
        String buttonOrder = ((ButtonBar)this.getSkinnable()).getButtonOrder();
        this.layout.getChildren().clear();
        if (buttonOrder == null) {
            throw new IllegalStateException("ButtonBar buttonOrder string can not be null");
        }
        if (buttonOrder.equals("")) {
            Spacer.DYNAMIC.add((Pane)this.layout, true);
            for (Node btn : buttons) {
                this.sizeButton(btn, buttonMinWidth, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add((Object)btn);
                HBox.setHgrow((Node)btn, (Priority)Priority.NEVER);
            }
        } else {
            this.doButtonOrderLayout(buttonOrder);
        }
    }

    private void doButtonOrderLayout(String buttonOrder) {
        int i;
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        ObservableList buttons = buttonBar.getButtons();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        Map buttonMap = this.buildButtonMap((List)buttons);
        char[] buttonOrderArr = buttonOrder.toCharArray();
        int buttonIndex = 0;
        Spacer spacer = Spacer.NONE;
        for (int i2 = 0; i2 < buttonOrderArr.length; ++i2) {
            char type = buttonOrderArr[i2];
            boolean edgeCase = buttonIndex <= 0 && buttonIndex >= buttons.size() - 1;
            boolean hasChildren = !this.layout.getChildren().isEmpty();
            List buttonList = (List)buttonMap.get(String.valueOf(type).toUpperCase());
            if (buttonList == null) continue;
            spacer.add((Pane)this.layout, edgeCase);
            for (Node btn : buttonList) {
                this.sizeButton(btn, buttonMinWidth, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add((Object)btn);
                HBox.setHgrow((Node)btn, (Priority)Priority.NEVER);
                ++buttonIndex;
            }
            spacer = spacer.replace(Spacer.NONE);
        }
        boolean isDefaultSet = false;
        int childrenCount = buttons.size();
        for (i = 0; i < childrenCount; ++i) {
            Node btn = (Node)buttons.get(i);
            if (!(btn instanceof Button) || !((Button)btn).isDefaultButton()) continue;
            btn.requestFocus();
            isDefaultSet = true;
            break;
        }
        if (!isDefaultSet) {
            for (i = 0; i < childrenCount; ++i) {
                Node btn = (Node)buttons.get(i);
                ButtonBar.ButtonData btnData = ButtonBar.getButtonData((Node)btn);
                if (btnData == null || !btnData.isDefaultButton()) continue;
                btn.requestFocus();
                isDefaultSet = true;
                break;
            }
        }
    }

    private void resizeButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        ObservableList buttons = buttonBar.getButtons();
        double widest = buttonMinWidth;
        for (Node button : buttons) {
            if (!ButtonBar.isButtonUniformSize((Node)button)) continue;
            widest = Math.max(button.prefWidth(-1.0), widest);
        }
        for (Node button : buttons) {
            if (!ButtonBar.isButtonUniformSize((Node)button)) continue;
            this.sizeButton(button, Double.MAX_VALUE, widest, Double.MAX_VALUE);
        }
    }

    private void sizeButton(Node btn, double min, double pref, double max) {
        if (btn instanceof Region) {
            Region regionBtn = (Region)btn;
            if (min != Double.MAX_VALUE) {
                regionBtn.setMinWidth(min);
            }
            if (pref != Double.MAX_VALUE) {
                regionBtn.setPrefWidth(pref);
            }
            if (max != Double.MAX_VALUE) {
                regionBtn.setMaxWidth(max);
            }
        }
    }

    private String getButtonType(Node btn) {
        String typeCode;
        ButtonBar.ButtonData buttonType = ButtonBar.getButtonData((Node)btn);
        if (buttonType == null) {
            buttonType = ButtonBar.ButtonData.OTHER;
        }
        typeCode = !(typeCode = buttonType.getTypeCode()).isEmpty() ? typeCode.substring(0, 1) : "";
        return CATEGORIZED_TYPES.contains(typeCode.toUpperCase()) ? typeCode : ButtonBar.ButtonData.OTHER.getTypeCode();
    }

    private Map<String, List<Node>> buildButtonMap(List<? extends Node> buttons) {
        HashMap<String, List<Node>> buttonMap = new HashMap<String, List<Node>>();
        for (Node node : buttons) {
            if (node == null) continue;
            String type = this.getButtonType(node);
            List typedButtons = buttonMap.computeIfAbsent(type, k -> new ArrayList());
            typedButtons.add(node);
        }
        return buttonMap;
    }
}

