/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.DurationPickerController;
import java.time.Duration;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@FxmlView(value="durationPicker.fxml")
public class DurationPickerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DurationPickerController.class);
    @FXML
    private HBox root;
    @FXML
    private JFXTextField hourTextField;
    @FXML
    private JFXTextField minuteTextField;
    @FXML
    private JFXTextField secondTextField;
    @FXML
    private JFXTextField millisecondTextField;

    @FXML
    public void initialize() {
        this.hourTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.hourTextField, 2, 24));
        this.minuteTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.minuteTextField, 2, 59));
        this.secondTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.secondTextField, 2, 59));
        this.millisecondTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.millisecondTextField, 3, 999));
        this.hourTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.hourTextField));
        this.minuteTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.minuteTextField));
        this.secondTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.secondTextField));
        this.millisecondTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.millisecondTextField));
        this.setupArrowKeys();
    }

    private void setupArrowKeys() {
        List<JFXTextField> fields = List.of(this.hourTextField, this.minuteTextField, this.secondTextField, this.millisecondTextField);
        for (JFXTextField node : fields) {
            node.setOnKeyPressed(event -> {
                if (event.getCode() == KeyCode.UP) {
                    this.modifyNumberOfTextField((TextField)node, 1);
                } else if (event.getCode() == KeyCode.DOWN) {
                    this.modifyNumberOfTextField((TextField)node, -1);
                }
            });
        }
    }

    public Duration getDuration() {
        try {
            return Duration.ofMillis((long)Integer.parseInt(this.millisecondTextField.getText()) + (long)Integer.parseInt(this.secondTextField.getText()) * 1000L + (long)Integer.parseInt(this.minuteTextField.getText()) * 1000L * 60L + (long)Integer.parseInt(this.hourTextField.getText()) * 1000L * 60L * 60L);
        }
        catch (NumberFormatException e) {
            log.error("Error parsing duration fields", (Throwable)e);
            return Duration.ZERO;
        }
    }

    public void setDuration(Duration duration) {
        long h = duration.toHours();
        long m = duration.toMinutesPart();
        long s = duration.toSecondsPart();
        long ms = duration.toMillisPart();
        this.hourTextField.setText(String.format("%02d", h));
        this.minuteTextField.setText(String.format("%02d", m));
        this.secondTextField.setText(String.format("%02d", s));
        this.millisecondTextField.setText(String.format("%03d", ms));
    }

    private void modifyNumberOfTextField(TextField node, int add) {
        try {
            int current = Integer.parseInt(node.getText());
            node.setText(String.valueOf(current + add));
        }
        catch (NumberFormatException e) {
            node.setText("00");
            log.debug("Could not modify number.", (Throwable)e);
        }
    }
}

