/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.jetbrains.annotations.NotNull;
import org.reactfx.Change;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@FxmlView(value="etPopOver.fxml")
public class ETPopOver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETPopOver.class);
    private final SimpleBooleanProperty showArrow = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty closeOnFocusLost = new SimpleBooleanProperty(true);
    private final SimpleDoubleProperty width = new SimpleDoubleProperty(310.0);
    @FXML
    private VBox container;
    @FXML
    private VBox content;
    @FXML
    private SVGPath arrow;
    @FXML
    private VBox root;
    private Stage stage;
    private int rootPadding = 0;
    private Node highlight;
    private Subscription positioningSubscription;

    public void initializeBindings() {
        this.arrow.visibleProperty().bind((ObservableValue)this.showArrow);
        this.container.prefWidthProperty().bind((ObservableValue)this.width);
    }

    public void show() throws IllegalStateException {
        this.checkIfDialogIsInitialized();
        this.stage.show();
        this.stage.toFront();
        if (this.positioningSubscription == null) {
            VBox.setMargin((Node)this.arrow, (Insets)new Insets(0.0, 0.0, 0.0, this.stage.getWidth() - 60.0));
            this.updatePositionSubscription();
        }
        this.stage.setOnHidden(windowEvent -> {
            if (this.positioningSubscription != null) {
                this.positioningSubscription.unsubscribe();
                this.positioningSubscription = null;
            }
        });
    }

    public void hide() throws IllegalStateException {
        this.checkIfDialogIsInitialized();
        this.stage.hide();
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    private void updatePositionSubscription() {
        if (this.highlight != null) {
            this.placePopupAboveHighlight(this.highlight);
            this.positioningSubscription = this.getPositioningStream(this.highlight).subscribe(bounds -> this.placePopupAboveHighlight(this.highlight));
        } else {
            this.placePopupInOwner();
            this.positioningSubscription = this.getPositioningStream((Node)this.stage.getOwner().getScene().getRoot()).subscribe(bounds -> this.placePopupInOwner());
        }
    }

    private EventStream<Either<Either<Change<Bounds>, Change<Number>>, Change<Number>>> getPositioningStream(Node node) {
        return EventStreams.changesOf((ObservableValue)node.boundsInParentProperty()).or(EventStreams.changesOf((ObservableValue)node.getScene().getWindow().xProperty())).or(EventStreams.changesOf((ObservableValue)node.getScene().getWindow().yProperty()));
    }

    private void placePopupAboveHighlight(@NotNull Node highlight) {
        Bounds boundsInScreen = highlight.localToScreen(highlight.getBoundsInLocal());
        int distanceToHighlight = -5;
        this.stage.setX(boundsInScreen.getCenterX() - VBox.getMargin((Node)this.arrow).getLeft() - this.arrow.getBoundsInLocal().getWidth() / 1.5);
        this.stage.setY(boundsInScreen.getMinY() - this.stage.getHeight() - (double)distanceToHighlight);
    }

    private void placePopupInOwner() {
        Window owner = this.stage.getOwner();
        Rectangle bounds = new Rectangle(owner.getX(), owner.getY(), owner.getWidth(), owner.getHeight());
        int distanceToHighlight = -5;
        this.stage.setX(bounds.getX() + bounds.getWidth() / 2.0 - this.stage.getWidth() / 2.0);
        this.stage.setY(bounds.getY() + this.stage.getHeight() + (double)distanceToHighlight);
    }

    private void checkIfDialogIsInitialized() {
        if (this.stage == null) {
            throw new IllegalStateException("Dialog is already closed or was never initialized.");
        }
    }

    public boolean getShowArrow() {
        return this.showArrow.get();
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow.set(showArrow);
    }

    public SimpleBooleanProperty showArrowProperty() {
        return this.showArrow;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost.get();
    }

    public void setCloseOnFocusLost(boolean closeOnFocusLost) {
        this.closeOnFocusLost.set(closeOnFocusLost);
    }

    public SimpleBooleanProperty closeOnFocusLostProperty() {
        return this.closeOnFocusLost;
    }

    public double getWidth() {
        return this.width.get();
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public SimpleDoubleProperty widthProperty() {
        return this.width;
    }

    @Generated
    public VBox getContent() {
        return this.content;
    }

    @Generated
    public VBox getRoot() {
        return this.root;
    }

    @Generated
    public Stage getStage() {
        return this.stage;
    }

    @Generated
    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @Generated
    public void setRootPadding(int rootPadding) {
        this.rootPadding = rootPadding;
    }

    @Generated
    public void setHighlight(Node highlight) {
        this.highlight = highlight;
    }
}

