/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.ProgressBarSkin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.reactfx.EventStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@FxmlView(value="etProgressBar.fxml")
public class ETProgressBarController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETProgressBarController.class);
    private final BooleanProperty changeable = new SimpleBooleanProperty(true);
    @FXML
    private AnchorPane root;
    @FXML
    private Slider progressSlider;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Pane progressPane;
    private Rectangle progressPaneClip;

    @FXML
    public void initialize() {
        this.setupSkinAndClipping();
        this.setupSliderLogic();
        this.progressSlider.mouseTransparentProperty().bind((ObservableValue)this.changeable.not());
        this.progressSlider.setCursor(Cursor.HAND);
    }

    private void setupSkinAndClipping() {
        EventStreams.changesOf((ObservableValue)this.progressBar.skinProperty()).subscribeForOne(skinChange -> {
            ProgressBarSkin skin = (ProgressBarSkin)this.progressBar.getSkin();
            Node bar = (Node)skin.getChildren().get(1);
            this.progressPaneClip = new Rectangle(bar.getLayoutBounds().getWidth(), 20.0);
            this.progressPaneClip.setLayoutX(bar.getLayoutX());
            this.progressPaneClip.setLayoutY(bar.getLayoutY());
            this.progressPane.setClip((Node)this.progressPaneClip);
            this.progressPane.setViewOrder(-100.0);
        });
    }

    private void setupSliderLogic() {
        this.progressSlider.valueProperty().addListener((observableValue, number, newValue) -> Platform.runLater(() -> {
            if (!this.progressSlider.isValueChanging()) {
                this.progressBar.setProgress((Double)newValue / this.progressSlider.getMax());
            }
            if (this.progressPaneClip != null) {
                this.progressPaneClip.setWidth(this.progressSlider.getWidth() * this.progressSlider.getValue() / this.progressSlider.getMax());
            }
        }));
        this.progressSlider.setOnMousePressed(event -> {
            if (!this.isChangeable()) {
                return;
            }
            this.progressSlider.setValueChanging(true);
            double value = event.getX() / this.progressSlider.getWidth() * this.progressSlider.getMax();
            this.progressSlider.setValue(value);
        });
        this.progressSlider.setOnMouseReleased(event -> {
            if (!this.isChangeable()) {
                return;
            }
            this.progressSlider.setValueChanging(false);
        });
    }

    public double getValue() {
        return this.progressSlider.getValue();
    }

    public void setValue(double value) {
        this.progressSlider.setValue(value);
        this.progressBar.setProgress(value);
    }

    public DoubleProperty valueProperty() {
        return this.progressSlider.valueProperty();
    }

    public BooleanProperty valueChangingProperty() {
        return this.progressSlider.valueChangingProperty();
    }

    public boolean isValueChanging() {
        return this.progressSlider.isValueChanging();
    }

    public void setMax(double max) {
        this.progressSlider.setMax(max);
    }

    public boolean isChangeable() {
        return this.changeable.get();
    }

    public void setChangeable(boolean changeable) {
        this.changeable.set(changeable);
    }

    public BooleanProperty changeableProperty() {
        return this.changeable;
    }

    @Generated
    public AnchorPane getRoot() {
        return this.root;
    }

    @Generated
    public Slider getProgressSlider() {
        return this.progressSlider;
    }

    @Generated
    public ProgressBar getProgressBar() {
        return this.progressBar;
    }
}

