/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETPopOver;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.ThemeService;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxWeaver;
import org.jetbrains.annotations.NotNull;
import org.reactfx.EventStreams;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PopOverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PopOverService.class);
    private final FxWeaver fxWeaver;
    private final MessageService messageService;
    private final AlertService alertService;
    private final ThemeService themeService;
    private final GuiStateService guiStateService;

    public ETPopOver create(@NotNull Window owner, Node highlight) {
        log.debug("Creating popover...");
        try {
            FxControllerAndView view = this.fxWeaver.load(ETPopOver.class, this.messageService.getLocaleBundle());
            ETPopOver etPopOver = (ETPopOver)view.getController();
            Parent node = (Parent)view.getView().orElseThrow(() -> new RuntimeException("Could not load view for ETPopOver"));
            Scene scene = new Scene(node);
            this.initStage(owner, etPopOver, scene);
            this.themeService.setStyleSheets(scene);
            etPopOver.setHighlight(highlight);
            log.debug("Popover created.");
            return etPopOver;
        }
        catch (Exception exception) {
            log.error("Could not open etPopOver.", (Throwable)exception);
            this.alertService.showServerError();
            return null;
        }
    }

    public ETPopOver showSnackbar(String title, String content, java.time.Duration duration) {
        Stage owner = this.guiStateService.getMainStage();
        if (owner == null) {
            log.warn("Cannot show snackbar: Main stage is null.");
            return null;
        }
        ETPopOver etPopOver = this.create((Window)owner, null);
        if (etPopOver == null) {
            return null;
        }
        etPopOver.setWidth(450.0);
        etPopOver.setShowArrow(false);
        etPopOver.setCloseOnFocusLost(false);
        etPopOver.getContent().getChildren().addAll((Object[])new Node[]{this.createHeadline(title), this.createText(content)});
        etPopOver.show();
        FadeTransition ft = new FadeTransition(Duration.millis((double)300.0), (Node)etPopOver.getRoot());
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.play();
        FxTimer.runLater((java.time.Duration)duration, () -> {
            FadeTransition fadeOut = new FadeTransition(Duration.millis((double)300.0), (Node)etPopOver.getRoot());
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            fadeOut.play();
            fadeOut.setOnFinished(e -> etPopOver.hide());
        });
        return etPopOver;
    }

    private void initStage(@NotNull Window owner, ETPopOver etPopOver, Scene scene) {
        if (etPopOver.getStage() != null) {
            throw new IllegalStateException("State is already initialized.");
        }
        Stage stage = new Stage();
        stage.initOwner(owner);
        stage.setResizable(false);
        stage.setScene(scene);
        stage.sizeToScene();
        EventStreams.changesOf((ObservableValue)stage.focusedProperty()).subscribe(focused -> {
            if (!((Boolean)focused.getNewValue()).booleanValue() && etPopOver.isCloseOnFocusLost()) {
                stage.hide();
            }
        });
        etPopOver.setStage(stage);
        etPopOver.initializeBindings();
        if (Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
            stage.initStyle(StageStyle.TRANSPARENT);
            scene.setFill((Paint)Color.TRANSPARENT);
            int rootPadding = 5;
            etPopOver.setRootPadding(rootPadding);
            etPopOver.getRoot().setPadding(new Insets(0.0, (double)rootPadding, (double)rootPadding, (double)rootPadding));
        } else {
            stage.initStyle(StageStyle.UNDECORATED);
        }
    }

    public VBox createHeadline(String text) {
        VBox headline = new VBox();
        headline.getStyleClass().add((Object)"et-popup-headline");
        List<SpacedText> spacedTexts = text.lines().map(line -> new SpacedText(line, Double.valueOf(1.38), "UPPER_CASE")).toList();
        headline.getChildren().addAll(spacedTexts);
        return headline;
    }

    public VBox createText(String text) {
        VBox textVBox = new VBox();
        textVBox.getStyleClass().add((Object)"et-popup-text");
        List<SpacedText> spacedTexts = text.lines().map(line -> new SpacedText(line, Double.valueOf(1.38))).toList();
        textVBox.getChildren().addAll(spacedTexts);
        return textVBox;
    }

    public Button createMenuItem(String text, Runnable onClick) {
        Button button = new Button();
        button.setText(text);
        button.getStyleClass().add((Object)"et-popup-menuitem");
        if (onClick != null) {
            button.setOnAction(event -> {
                onClick.run();
                button.getScene().getWindow().hide();
            });
        }
        return button;
    }

    @Generated
    public PopOverService(FxWeaver fxWeaver, MessageService messageService, AlertService alertService, ThemeService themeService, GuiStateService guiStateService) {
        this.fxWeaver = fxWeaver;
        this.messageService = messageService;
        this.alertService = alertService;
        this.themeService = themeService;
        this.guiStateService = guiStateService;
    }
}

