/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.controlsfx.control.PopOver;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@FxmlView(value="timestampFormatting.fxml")
public class TimestampFormattingController {
    private final MessageService messageService;
    @FXML
    private JFXTextField timestampsFormatTextField;
    @FXML
    private Button infoButton;

    @FXML
    public void initialize() {
        this.setupPopOver();
    }

    private void setupPopOver() {
        PopOver popOver = new PopOver();
        VBox popOverContent = new VBox();
        popOverContent.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        ResourceBundle bundle = this.messageService.getLocaleBundle();
        popOverContent.getChildren().addAll((Object[])new Node[]{new Label(bundle.getString("timestampHint.allowedSymbols")), new Label(), new Label("H = " + bundle.getString("timestampHint.hour")), new Label("m = " + bundle.getString("timestampHint.minuteOfHour")), new Label("s = " + bundle.getString("timestampHint.secondOfMinute")), new Label("S = " + bundle.getString("timestampHint.millisecond")), new Label("'#' = " + bundle.getString("timestampHint.misc")), new Label(), new Label(bundle.getString("timestampHint.example")), new Label("'#'HH:mm:ss-SSS'#'")});
        popOver.setContentNode((Node)popOverContent);
        popOver.setAnimated(false);
        popOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
        this.infoButton.hoverProperty().addListener((obs, wasHovering, isHovering) -> {
            if (isHovering.booleanValue()) {
                Bounds bounds = this.infoButton.localToScreen(this.infoButton.getBoundsInLocal());
                popOver.show((Node)this.infoButton, bounds.getMinX() + bounds.getWidth() / 2.0 - 10.0, bounds.getMinY() + bounds.getHeight() + 2.0);
            } else {
                popOver.hide();
            }
        });
        popOver.getRoot().setPickOnBounds(false);
        popOver.getContentNode().setPickOnBounds(false);
    }

    @Generated
    public TimestampFormattingController(MessageService messageService) {
        this.messageService = messageService;
    }

    @Generated
    public JFXTextField getTimestampsFormatTextField() {
        return this.timestampsFormatTextField;
    }
}

