/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.UndoManagerNoCheck;
import java.time.Duration;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import lombok.Generated;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.impl.ChangeQueue;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.SuspendableNo;
import org.reactfx.value.Val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoManagerNoCheck<C>
implements UndoManager<C> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UndoManagerNoCheck.class);
    private final ChangeQueue<C> queue;
    private final Function<? super C, ? extends C> invert;
    private final Consumer<C> apply;
    private final BiFunction<C, C, Optional<C>> merge;
    private final Predicate<C> isIdentity;
    private final Subscription subscription;
    private final SuspendableNo performingAction = new SuspendableNo();
    private final EventSource<Void> invalidationRequests = new EventSource();
    private final Val<C> nextUndo = new /* Unavailable Anonymous Inner Class!! */;
    private final Val<C> nextRedo = new /* Unavailable Anonymous Inner Class!! */;
    private boolean canMerge;
    private ChangeQueue.QueuePosition mark;
    private final BooleanBinding atMarkedPosition = new /* Unavailable Anonymous Inner Class!! */;
    private C expectedChange = null;

    public UndoManagerNoCheck(ChangeQueue<C> queue, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, EventStream<C> changeSource) {
        this(queue, invert, apply, merge, isIdentity, changeSource, Duration.ZERO);
    }

    public UndoManagerNoCheck(ChangeQueue<C> queue, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, EventStream<C> changeSource, Duration preventMergeDelay) {
        this.queue = queue;
        this.invert = invert;
        this.apply = apply;
        this.merge = merge;
        this.isIdentity = isIdentity;
        this.mark = queue.getCurrentPosition();
        Subscription mainSub = changeSource.subscribe(arg_0 -> this.changeObserved(arg_0));
        if (preventMergeDelay.isZero() || preventMergeDelay.isNegative()) {
            this.subscription = mainSub;
        } else {
            Subscription sub2 = changeSource.successionEnds(preventMergeDelay).subscribe(ignore -> this.preventMerge());
            this.subscription = mainSub.and(sub2);
        }
    }

    public void close() {
        this.subscription.unsubscribe();
    }

    public boolean undo() {
        return this.applyChange(this.isUndoAvailable(), () -> this.invert.apply(this.queue.prev()));
    }

    public boolean redo() {
        return this.applyChange(this.isRedoAvailable(), () -> ((ChangeQueue)this.queue).next());
    }

    public Val<C> nextUndoProperty() {
        return this.nextUndo;
    }

    public Val<C> nextRedoProperty() {
        return this.nextRedo;
    }

    public boolean isUndoAvailable() {
        return this.nextUndo.isPresent();
    }

    public Val<Boolean> undoAvailableProperty() {
        return this.nextUndo.map(c -> true).orElseConst((Object)false);
    }

    public boolean isRedoAvailable() {
        return this.nextRedo.isPresent();
    }

    public Val<Boolean> redoAvailableProperty() {
        return this.nextRedo.map(c -> true).orElseConst((Object)false);
    }

    public boolean isPerformingAction() {
        return this.performingAction.get();
    }

    public ObservableBooleanValue performingActionProperty() {
        return this.performingAction;
    }

    public boolean isAtMarkedPosition() {
        return this.atMarkedPosition.get();
    }

    public ObservableBooleanValue atMarkedPositionProperty() {
        return this.atMarkedPosition;
    }

    public UndoManager.UndoPosition getCurrentPosition() {
        return new UndoPositionImpl(this, this.queue.getCurrentPosition());
    }

    public void preventMerge() {
        this.canMerge = false;
    }

    public void forgetHistory() {
        this.queue.forgetHistory();
        this.invalidateProperties();
    }

    private boolean applyChange(boolean isChangeAvailable, Supplier<C> changeToApply) {
        if (isChangeAvailable) {
            this.canMerge = false;
            C change = changeToApply.get();
            this.expectedChange = change;
            this.performingAction.suspendWhile(() -> this.apply.accept(change));
            if (this.expectedChange != null) {
                throw new IllegalStateException("Expected change not received:\n" + String.valueOf(this.expectedChange));
            }
            this.invalidateProperties();
            return true;
        }
        return false;
    }

    private void changeObserved(C change) {
        if (this.expectedChange == null) {
            if (!this.isIdentity.test(change)) {
                this.addChange(change);
            }
        } else {
            if (!this.expectedChange.equals(change)) {
                log.warn("Unexpected changes.");
                log.debug("Expected: {}", this.expectedChange);
                log.debug("Received: {}", change);
            }
            this.expectedChange = null;
        }
    }

    private void addChange(C change) {
        if (this.canMerge && this.queue.hasPrev()) {
            Object prev = this.queue.prev();
            Optional merged = (Optional)this.merge.apply(prev, change);
            if (merged.isPresent()) {
                if (this.isIdentity.test(merged.get())) {
                    this.canMerge = false;
                    this.queue.push(new Object[0]);
                } else {
                    this.canMerge = true;
                    this.queue.push(new Object[]{merged.get()});
                }
            } else {
                this.canMerge = true;
                this.queue.next();
                this.queue.push(new Object[]{change});
            }
        } else {
            this.queue.push(new Object[]{change});
            this.canMerge = true;
        }
        this.invalidateProperties();
    }

    private void invalidateProperties() {
        this.invalidationRequests.push(null);
    }
}

