/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.cache.CachePolicy;
import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.events.JFXDrawerEvent;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXDrawerKeyValue;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.CustomDrawer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDrawer
extends StackPane {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomDrawer.class);
    private static final String DEFAULT_STYLE_CLASS = "jfx-drawer";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load((String)"css/controls/jfx-drawer.css").toExternalForm();
    private final List<JFXKeyValue<?>> animatedValues = new ArrayList();
    private final HashMap<WritableValue<?>, JFXDrawerKeyValue<?>> initValues = new HashMap();
    private final HashMap<WritableValue<?>, Supplier<?>> currentValue = new HashMap();
    private final StackPane overlayPane = new StackPane();
    private final StackPane content = new StackPane();
    private final StackPane contentHolder = new StackPane();
    private final Region paddingPane = new Region();
    private final Duration holdTime = Duration.seconds((double)0.2);
    private final PauseTransition holdTimer = new PauseTransition(this.holdTime);
    private final double initOffset = 30.0;
    private final DoubleProperty initTranslate = new SimpleDoubleProperty();
    private final double activeOffset = 20.0;
    private final DoubleProperty defaultSizeProperty = new SimpleDoubleProperty();
    private final Duration duration;
    private final DoubleProperty miniDrawerSize = new SimpleDoubleProperty(-1.0);
    private final ArrayList<Callback<Void, Boolean>> callBacks = new ArrayList();
    private final SimpleObjectProperty<JFXDrawer.DrawerDirection> directionProperty = new SimpleObjectProperty((Object)JFXDrawer.DrawerDirection.LEFT);
    private final SimpleObjectProperty<CachePolicy> cachePolicy = new SimpleObjectProperty((Object)CachePolicy.NONE);
    private final BooleanProperty overLayVisible = new SimpleBooleanProperty(true);
    private final ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosed = new /* Unavailable Anonymous Inner Class!! */;
    private final ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosing = new /* Unavailable Anonymous Inner Class!! */;
    private final ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpened = new /* Unavailable Anonymous Inner Class!! */;
    private final ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpening = new /* Unavailable Anonymous Inner Class!! */;
    StackPane sidePane = new StackPane();
    private double startMouse = -1.0;
    private double startTranslate = -1.0;
    private double startSize = -1.0;
    private double contentMinSize = -1.0;
    private boolean openCalled = false;
    private boolean closeCalled = true;
    private DoubleProperty translateProperty = this.sidePane.translateXProperty();
    private DoubleProperty maxSizeProperty = this.sidePane.maxWidthProperty();
    private DoubleProperty prefSizeProperty = this.sidePane.prefWidthProperty();
    private ReadOnlyDoubleProperty sizeProperty = this.sidePane.widthProperty();
    private DoubleProperty paddingSizeProperty = this.paddingPane.minWidthProperty();
    private double translateTo = 0.0;
    private double resizeTo = 0.0;
    private DoubleBinding initTranslateBinding;
    private double tempDrawerSize = this.getDefaultDrawerSize();
    private JFXAnimationTimer translateTimer;
    private final EventHandler<MouseEvent> mouseReleasedHandler = mouseEvent -> {
        double direction = ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue();
        if (this.prefSizeProperty.get() != -1.0) {
            this.tryPartialAnimation(direction);
            this.updateTempDrawerSize();
        }
        this.startMouse = -1.0;
        this.startTranslate = -1.0;
        this.startSize = this.sizeProperty.get();
    };
    private boolean resizable = false;
    private boolean resizeContent = false;
    private final EventHandler<MouseEvent> mouseDragHandler = mouseEvent -> {
        if (!mouseEvent.isConsumed()) {
            double sizeLimit;
            mouseEvent.consume();
            if (this.startSize == -1.0) {
                this.startSize = this.sizeProperty.get();
            }
            double directionValue = this.getDirection().doubleValue();
            double eventPoint = this.getDirection() == JFXDrawer.DrawerDirection.RIGHT || this.getDirection() == JFXDrawer.DrawerDirection.LEFT ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
            double mouseDiff = this.startTranslate + eventPoint - this.startMouse;
            double d = sizeLimit = this.getDirection() == JFXDrawer.DrawerDirection.LEFT || this.getDirection() == JFXDrawer.DrawerDirection.RIGHT ? this.getWidth() : this.getHeight();
            if (directionValue * mouseDiff <= 0.0) {
                if (this.resizable || this.hasMiniSize()) {
                    double newSize = this.startSize + directionValue * mouseDiff;
                    double drawerMinSize = this.hasMiniSize() ? this.getMiniDrawerSize() : this.getDefaultDrawerSize();
                    if (newSize > drawerMinSize) {
                        this.maxSizeProperty.set(newSize);
                        this.prefSizeProperty.set(newSize);
                        double opacity = this.hasMiniSize() ? (newSize - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        opacity = opacity > 1.0 ? 1.0 : opacity;
                        opacity = opacity < 0.0 ? 0.0 : opacity;
                        this.overlayPane.setOpacity(opacity);
                        for (JFXKeyValue value : this.animatedValues) {
                            if (!value.isValid()) continue;
                            WritableValue target = value.getTarget();
                            JFXDrawerKeyValue initValue = (JFXDrawerKeyValue)this.initValues.get(target);
                            target.setValue(value.getInterpolator().interpolate(initValue.getOpenValueSupplier().get(), initValue.getCloseValueSupplier().get(), 1.0 - opacity));
                        }
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(Math.min(newSize, sizeLimit - this.contentMinSize));
                        }
                    } else {
                        this.maxSizeProperty.set(drawerMinSize);
                        double translation = this.hasMiniSize() ? 0.0 : directionValue * (this.startSize - this.getDefaultDrawerSize()) + mouseDiff;
                        this.translateProperty.set(translation);
                        double opacity = this.hasMiniSize() ? (newSize - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        opacity = opacity > 1.0 ? 1.0 : opacity;
                        opacity = opacity < 0.0 ? 0.0 : opacity;
                        this.overlayPane.setOpacity(opacity);
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(drawerMinSize + directionValue * translation);
                        }
                    }
                } else {
                    this.translateProperty.set(mouseDiff);
                    this.overlayPane.setOpacity(1.0 - this.translateProperty.get() / this.initTranslate.get());
                    if (this.isResizeContent()) {
                        this.paddingSizeProperty.set(this.getDefaultDrawerSize() + directionValue * mouseDiff);
                    }
                }
            } else {
                if (this.resizable || this.hasMiniSize()) {
                    double newSize = this.startSize + directionValue * mouseDiff;
                    if (newSize <= sizeLimit) {
                        newSize = this.resizable ? newSize : (newSize < this.getDefaultDrawerSize() ? newSize : this.getDefaultDrawerSize());
                        this.maxSizeProperty.set(newSize);
                        this.prefSizeProperty.set(newSize);
                        double opacity = this.hasMiniSize() ? (newSize - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        opacity = opacity > 1.0 ? 1.0 : opacity;
                        opacity = opacity < 0.0 ? 0.0 : opacity;
                        this.overlayPane.setOpacity(opacity);
                        for (JFXKeyValue value : this.animatedValues) {
                            if (!value.isValid()) continue;
                            WritableValue target = value.getTarget();
                            JFXDrawerKeyValue initValue = (JFXDrawerKeyValue)this.initValues.get(target);
                            target.setValue(value.getInterpolator().interpolate(initValue.getCloseValueSupplier().get(), initValue.getOpenValueSupplier().get(), opacity));
                        }
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(Math.min(newSize, sizeLimit - this.contentMinSize));
                        }
                    } else if (this.resizable) {
                        this.maxSizeProperty.set(-1.0);
                        this.prefSizeProperty.set(-1.0);
                    }
                }
                this.translateProperty.set(0.0);
                if (!this.hasMiniSize()) {
                    this.overlayPane.setOpacity(1.0 - this.translateProperty.get() / this.initTranslate.get());
                }
            }
        }
    };
    private final EventHandler<MouseEvent> mousePressedHandler = mouseEvent -> {
        this.translateTimer.setOnFinished(null);
        this.translateTimer.stop();
        this.startMouse = this.directionProperty.get() == JFXDrawer.DrawerDirection.RIGHT || this.directionProperty.get() == JFXDrawer.DrawerDirection.LEFT ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
        this.startTranslate = this.translateProperty.get();
        this.startSize = this.sizeProperty.get();
        this.contentMinSize = -1.0;
        if (this.isResizeContent()) {
            this.contentMinSize = this.getDirection() == JFXDrawer.DrawerDirection.LEFT || this.getDirection() == JFXDrawer.DrawerDirection.RIGHT ? this.content.minWidth(-1.0) : this.content.minHeight(-1.0);
        }
    };

    public CustomDrawer() {
        this(Duration.millis((double)420.0));
    }

    public CustomDrawer(Duration duration) {
        this.initialize();
        this.duration = duration;
        this.translateTimer = this.createDrawerAnimation(duration);
        this.contentHolder.setPickOnBounds(false);
        this.addEventHandler(JFXDrawerEvent.CLOSED, handler -> Platform.runLater(() -> this.getCachePolicy().restore((Node)this.contentHolder)));
        this.overlayPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.1), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.overlayPane.getStyleClass().add((Object)"jfx-drawer-overlay-pane");
        this.overlayPane.setOpacity(0.0);
        this.overlayPane.setMouseTransparent(true);
        this.sidePane.getStyleClass().add((Object)"jfx-drawer-side-pane");
        this.sidePane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.sidePane.setPickOnBounds(false);
        this.translateTimer.setCacheNodes(new Node[]{this.sidePane});
        this.initListeners();
        this.setDefaultDrawerSize(100.0);
        this.getChildren().setAll((Object[])new Node[]{this.contentHolder, this.overlayPane, this.sidePane});
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    private void initListeners() {
        this.initTranslateBinding = Bindings.createDoubleBinding(() -> -1.0 * ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue() * this.defaultSizeProperty.getValue() - 30.0 * ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue(), (Observable[])new Observable[]{this.defaultSizeProperty, this.directionProperty});
        this.updateDirection(this.getDirection());
        this.initTranslate.bind((ObservableValue)this.initTranslateBinding);
        this.overLayVisibleProperty().addListener(observable -> {
            boolean visible = this.isOverLayVisible();
            this.overlayPane.setStyle(!visible ? "-fx-background-color : transparent;" : "");
            this.overlayPane.setPickOnBounds(visible);
        });
        this.directionProperty.addListener(observable -> this.updateDirection((JFXDrawer.DrawerDirection)this.directionProperty.get()));
        this.initTranslate.addListener(observable -> this.updateDrawerAnimation(this.initTranslate.get()));
        this.translateProperty.addListener((o, oldVal, newVal) -> {
            if (!this.openCalled && this.closeCalled && ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue() * newVal.doubleValue() > ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue() * this.initTranslate.get() / 2.0) {
                this.openCalled = true;
                this.closeCalled = false;
                this.fireEvent((Event)new JFXDrawerEvent(JFXDrawerEvent.OPENING));
            }
        });
        this.translateProperty.addListener((o, oldVal, newVal) -> {
            if (this.openCalled && !this.closeCalled && ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue() * newVal.doubleValue() < ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue() * this.initTranslate.get() / 2.0) {
                this.closeCalled = true;
                this.openCalled = false;
                this.fireEvent((Event)new JFXDrawerEvent(JFXDrawerEvent.CLOSING));
            }
        });
        this.overlayPane.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.close());
        this.content.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            if (!e.isConsumed()) {
                double size = 0.0;
                long valid = 0L;
                for (int i = 0; i < this.callBacks.size(); ++i) {
                    if (((Boolean)((Callback)this.callBacks.get(i)).call(null)).booleanValue()) continue;
                    ++valid;
                }
                JFXDrawer.DrawerDirection direction = this.getDirection();
                if (direction == JFXDrawer.DrawerDirection.RIGHT) {
                    size = this.content.getWidth();
                } else if (direction == JFXDrawer.DrawerDirection.BOTTOM) {
                    size = this.content.getHeight();
                }
                double eventPoint = 0.0;
                eventPoint = direction == JFXDrawer.DrawerDirection.RIGHT || direction == JFXDrawer.DrawerDirection.LEFT ? e.getX() : e.getY();
                if (size + direction.doubleValue() * eventPoint < 20.0 && (this.content.getCursor() == null || this.content.getCursor() == Cursor.DEFAULT) && valid == 0L && !this.isOpened()) {
                    this.holdTimer.play();
                    e.consume();
                }
            }
        });
        this.content.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            this.holdTimer.stop();
            this.content.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDragHandler);
        });
        this.holdTimer.setOnFinished(e -> {
            this.translateTo = this.initTranslate.get() + 30.0 * ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue() + 20.0 * ((JFXDrawer.DrawerDirection)this.directionProperty.get()).doubleValue();
            this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
            this.translateTimer.setOnFinished(null);
            this.getCachePolicy().cache((Node)this.contentHolder);
            this.translateTimer.start();
        });
    }

    private JFXAnimationTimer createDrawerAnimation(Duration duration) {
        return new JFXAnimationTimer(new JFXKeyFrame[]{new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.overlayPane.opacityProperty()).setEndValueSupplier(() -> !this.hasMiniSize() ? 1.0 - this.translateTo / this.initTranslate.get() : (double)(this.resizeTo != this.getMiniDrawerSize() ? 1 : 0)).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.translateProperty).setEndValueSupplier(() -> !this.hasMiniSize() ? this.translateTo : 0.0).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> !this.hasMiniSize() && this.translateTo == this.initTranslate.get()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> !this.hasMiniSize() && this.translateTo == this.initTranslate.get()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.tempDrawerSize).setAnimateCondition(() -> this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize() && !this.hasMiniSize()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.tempDrawerSize).setAnimateCondition(() -> this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize() && !this.hasMiniSize()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getMiniDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo <= this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getMiniDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo <= this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo > this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo > this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()}), new JFXKeyFrame(duration, new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> this.paddingSizeProperty).setEndValueSupplier(() -> this.computePaddingSize()).setAnimateCondition(() -> this.isResizeContent()).setInterpolator(Interpolator.EASE_BOTH).build()})});
    }

    private void updateDirection(JFXDrawer.DrawerDirection dir) {
        this.maxSizeProperty.set(-1.0);
        this.prefSizeProperty.set(-1.0);
        this.translateProperty.set(0.0);
        if (dir == JFXDrawer.DrawerDirection.LEFT || dir == JFXDrawer.DrawerDirection.RIGHT) {
            this.translateProperty = this.sidePane.translateXProperty();
            this.maxSizeProperty = this.sidePane.maxWidthProperty();
            this.prefSizeProperty = this.sidePane.prefWidthProperty();
            this.sizeProperty = this.sidePane.widthProperty();
            this.paddingSizeProperty = this.paddingPane.minWidthProperty();
        } else if (dir == JFXDrawer.DrawerDirection.TOP || dir == JFXDrawer.DrawerDirection.BOTTOM) {
            this.translateProperty = this.sidePane.translateYProperty();
            this.maxSizeProperty = this.sidePane.maxHeightProperty();
            this.prefSizeProperty = this.sidePane.prefHeightProperty();
            this.sizeProperty = this.sidePane.heightProperty();
            this.paddingSizeProperty = this.paddingPane.minHeightProperty();
        }
        if (dir == JFXDrawer.DrawerDirection.LEFT) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.CENTER_LEFT);
        } else if (dir == JFXDrawer.DrawerDirection.RIGHT) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.CENTER_RIGHT);
        } else if (dir == JFXDrawer.DrawerDirection.TOP) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.TOP_CENTER);
        } else if (dir == JFXDrawer.DrawerDirection.BOTTOM) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.BOTTOM_CENTER);
        }
        this.setDefaultDrawerSize(this.getDefaultDrawerSize());
        this.updateDrawerAnimation(this.initTranslate.get());
        this.updateContent();
        this.setMiniDrawerSize(this.getMiniDrawerSize());
    }

    private void updateDrawerAnimation(double translation) {
        this.translateProperty.set(translation);
        this.translateTo = translation;
    }

    private double computePaddingSize() {
        if (!this.isResizeContent()) {
            return 0.0;
        }
        if (this.hasMiniSize()) {
            return this.resizeTo;
        }
        if (this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize()) {
            return this.tempDrawerSize;
        }
        if (this.translateTo == 0.0) {
            return this.getDefaultDrawerSize();
        }
        if (this.translateTo == this.initTranslate.get()) {
            return 0.0;
        }
        return this.getDefaultDrawerSize() + this.getDirection().doubleValue() * this.translateTo;
    }

    public double getMiniDrawerSize() {
        return this.miniDrawerSize.get();
    }

    public void setMiniDrawerSize(double size) {
        this.miniDrawerSize.set(size);
        if (size > 0.0) {
            this.updateSize(size);
            this.initTranslate.unbind();
            this.initTranslate.set(0.0);
            this.paddingSizeProperty.set(size);
        } else {
            this.updateSize(this.getDefaultDrawerSize());
            this.initTranslate.bind((ObservableValue)this.initTranslateBinding);
            this.paddingSizeProperty.set(0.0);
        }
        this.resizeTo = size;
    }

    private boolean hasMiniSize() {
        return this.getMiniDrawerSize() > 0.0;
    }

    public void addInitDrawerCallback(Callback<Void, Boolean> callBack) {
        this.callBacks.add(callBack);
    }

    void bringToFront(Callback<Void, Void> callback) {
        EventHandler eventFilter = Event::consume;
        boolean fillSize = this.prefSizeProperty.get() == -1.0;
        this.addEventFilter(MouseEvent.ANY, eventFilter);
        Runnable onFinished = () -> {
            callback.call(null);
            this.translateTo = 0.0;
            this.translateTimer.setOnFinished(() -> {
                if (fillSize) {
                    this.prefSizeProperty.set(-1.0);
                    this.maxSizeProperty.set(-1.0);
                }
                this.removeEventFilter(MouseEvent.ANY, eventFilter);
            });
            this.getCachePolicy().cache((Node)this.contentHolder);
            this.translateTimer.start();
        };
        this.tempDrawerSize = this.sizeProperty.get() > this.getDefaultDrawerSize() ? this.sizeProperty.get() : this.getDefaultDrawerSize();
        this.translateTo = this.initTranslate.get();
        this.translateTimer.setOnFinished(onFinished);
        this.getCachePolicy().cache((Node)this.contentHolder);
        this.translateTimer.start();
    }

    public boolean isOpened() {
        if (this.hasMiniSize()) {
            return this.resizeTo == this.getDefaultDrawerSize() || this.prefSizeProperty.get() >= this.getDefaultDrawerSize();
        }
        return (this.translateTo == 0.0 || this.translateProperty.get() == 0.0) && !this.translateTimer.isRunning();
    }

    public boolean isOpening() {
        boolean condition = this.hasMiniSize() ? this.resizeTo == this.getDefaultDrawerSize() : this.translateTo == 0.0;
        return condition && this.translateTimer.isRunning();
    }

    public boolean isClosing() {
        boolean condition = this.hasMiniSize() ? this.resizeTo == this.getMiniDrawerSize() : this.translateTo == this.initTranslate.get();
        return condition && this.translateTimer.isRunning();
    }

    public boolean isClosed() {
        if (this.hasMiniSize()) {
            return this.resizeTo == this.getMiniDrawerSize();
        }
        return this.translateTo == this.initTranslate.get() && !this.translateTimer.isRunning();
    }

    public void toggle() {
        if (this.isOpened() || this.isOpening()) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() {
        for (Map.Entry entry : this.initValues.entrySet()) {
            this.currentValue.put((WritableValue)entry.getKey(), ((JFXDrawerKeyValue)entry.getValue()).getOpenValueSupplier());
        }
        this.translateTo = 0.0;
        this.resizeTo = this.getDefaultDrawerSize();
        this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
        this.translateTimer.setOnFinished(() -> this.fireEvent((Event)new JFXDrawerEvent(JFXDrawerEvent.OPENED)));
        this.getCachePolicy().cache((Node)this.contentHolder);
        this.translateTimer.reverseAndContinue();
    }

    public void close() {
        this.translateTimer.setOnFinished(() -> {
            this.overlayPane.setMouseTransparent(true);
            this.fireEvent((Event)new JFXDrawerEvent(JFXDrawerEvent.CLOSED));
        });
        if (this.hasMiniSize()) {
            if (this.resizeTo != this.getMiniDrawerSize()) {
                this.resizeTo = this.getMiniDrawerSize();
                for (Map.Entry entry : this.initValues.entrySet()) {
                    this.currentValue.put((WritableValue)entry.getKey(), ((JFXDrawerKeyValue)entry.getValue()).getCloseValueSupplier());
                }
            }
        } else {
            this.updateTempDrawerSize();
            if (this.translateTo != this.initTranslate.get()) {
                this.translateTo = this.initTranslate.get();
                for (Map.Entry entry : this.initValues.entrySet()) {
                    this.currentValue.put((WritableValue)entry.getKey(), ((JFXDrawerKeyValue)entry.getValue()).getCloseValueSupplier());
                }
            }
        }
        this.getCachePolicy().cache((Node)this.contentHolder);
        this.translateTimer.reverseAndContinue();
    }

    public ObservableList<Node> getSidePane() {
        return this.sidePane.getChildren();
    }

    public void setSidePane(Node ... sidePane) {
        this.sidePane.getChildren().setAll((Object[])sidePane);
    }

    public ObservableList<Node> getContent() {
        if (this.contentHolder.getChildren().isEmpty()) {
            this.updateContent();
        }
        return this.content.getChildren();
    }

    public void setContent(Node ... content) {
        this.content.getChildren().setAll((Object[])content);
        if (this.contentHolder.getChildren().isEmpty()) {
            this.updateContent();
        }
    }

    private void updateContent() {
        this.paddingPane.setPrefSize(0.0, 0.0);
        this.paddingPane.setMinSize(0.0, 0.0);
        StackPane contentNode = this.content;
        switch (5.$SwitchMap$com$jfoenix$controls$JFXDrawer$DrawerDirection[this.getDirection().ordinal()]) {
            case 1: {
                contentNode = new VBox(new Node[]{this.paddingPane, this.content});
                VBox.setVgrow((Node)this.content, (Priority)Priority.ALWAYS);
                break;
            }
            case 2: {
                contentNode = new VBox(new Node[]{this.content, this.paddingPane});
                VBox.setVgrow((Node)this.content, (Priority)Priority.ALWAYS);
                break;
            }
            case 3: {
                contentNode = new HBox(new Node[]{this.paddingPane, this.content});
                HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
                break;
            }
            case 4: {
                contentNode = new HBox(new Node[]{this.content, this.paddingPane});
                HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            }
        }
        contentNode.setPickOnBounds(false);
        if (this.isOpened()) {
            this.paddingSizeProperty.set(this.computePaddingSize());
        }
        this.contentHolder.getChildren().setAll((Object[])new Node[]{contentNode});
    }

    public double getDefaultDrawerSize() {
        return this.defaultSizeProperty.get();
    }

    public void setDefaultDrawerSize(double size) {
        this.defaultSizeProperty.set(size);
        if (this.getMiniDrawerSize() < 0.0) {
            this.updateSize(size);
        }
    }

    private void updateSize(double size) {
        this.maxSizeProperty.set(size);
        this.prefSizeProperty.set(size);
    }

    public JFXDrawer.DrawerDirection getDirection() {
        return (JFXDrawer.DrawerDirection)this.directionProperty.get();
    }

    public void setDirection(JFXDrawer.DrawerDirection direction) {
        this.directionProperty.set((Object)direction);
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy.get() == null ? CachePolicy.NONE : (CachePolicy)this.cachePolicy.get();
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy.set((Object)cachePolicy);
    }

    public final BooleanProperty overLayVisibleProperty() {
        return this.overLayVisible;
    }

    public final boolean isOverLayVisible() {
        return this.overLayVisibleProperty().get();
    }

    public final void setOverLayVisible(boolean overLayVisible) {
        this.overLayVisibleProperty().set(overLayVisible);
    }

    public boolean isResizableOnDrag() {
        return this.resizable;
    }

    public void setResizableOnDrag(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isResizeContent() {
        return this.resizeContent;
    }

    public void setResizeContent(boolean resizeContent) {
        this.resizeContent = resizeContent;
        this.translateTimer.reverseAndContinue();
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerClosed() {
        return (EventHandler)this.onDrawerClosedProperty().get();
    }

    public void setOnDrawerClosed(EventHandler<JFXDrawerEvent> onDrawerClosed) {
        this.onDrawerClosedProperty().set(onDrawerClosed);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerClosing() {
        return (EventHandler)this.onDrawerClosing.get();
    }

    public void setOnDrawerClosing(EventHandler<JFXDrawerEvent> onDrawerClosing) {
        this.onDrawerClosing.set(onDrawerClosing);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerOpened() {
        return (EventHandler)this.onDrawerOpened.get();
    }

    public void setOnDrawerOpened(EventHandler<JFXDrawerEvent> onDrawerOpened) {
        this.onDrawerOpened.set(onDrawerOpened);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerOpening() {
        return (EventHandler)this.onDrawerOpening.get();
    }

    public void setOnDrawerOpening(EventHandler<JFXDrawerEvent> onDrawerOpening) {
        this.onDrawerOpening.set(onDrawerOpening);
    }

    public SimpleObjectProperty<JFXDrawer.DrawerDirection> directionProperty() {
        return this.directionProperty;
    }

    public SimpleObjectProperty<CachePolicy> cachePolicyProperty() {
        return this.cachePolicy;
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosedProperty() {
        return this.onDrawerClosed;
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosingProperty() {
        return this.onDrawerClosing;
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpenedProperty() {
        return this.onDrawerOpened;
    }

    private void updateTempDrawerSize() {
        this.tempDrawerSize = this.sizeProperty.get() > this.getDefaultDrawerSize() ? this.prefSizeProperty.get() : this.getDefaultDrawerSize();
    }

    private void tryPartialAnimation(double direction) {
        if (this.hasMiniSize()) {
            if (this.prefSizeProperty.get() > (this.getMiniDrawerSize() + this.getDefaultDrawerSize()) / 2.0 && this.prefSizeProperty.get() < this.getDefaultDrawerSize()) {
                this.partialOpen();
            } else if (this.prefSizeProperty.get() <= (this.getMiniDrawerSize() + this.getDefaultDrawerSize()) / 2.0) {
                this.partialClose();
            } else if (this.prefSizeProperty.get() >= this.getDefaultDrawerSize()) {
                this.resizeTo = this.getDefaultDrawerSize();
                this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
            }
        } else if (direction * this.translateProperty.get() > direction * this.initTranslate.get() / 2.0) {
            if (this.translateProperty.get() != 0.0) {
                this.partialOpen();
            }
        } else if (this.translateProperty.get() != this.initTranslate.get()) {
            this.partialClose();
        }
    }

    private void partialClose() {
        for (Map.Entry entry : this.initValues.entrySet()) {
            this.currentValue.put((WritableValue)entry.getKey(), ((JFXDrawerKeyValue)entry.getValue()).getCloseValueSupplier());
        }
        this.translateTo = this.initTranslate.get();
        this.resizeTo = this.getMiniDrawerSize();
        this.translateTimer.setOnFinished(() -> {
            this.overlayPane.setMouseTransparent(true);
            this.fireEvent((Event)new JFXDrawerEvent(JFXDrawerEvent.CLOSED));
        });
        this.getCachePolicy().cache((Node)this.contentHolder);
        this.translateTimer.start();
    }

    private void partialOpen() {
        for (Map.Entry entry : this.initValues.entrySet()) {
            this.currentValue.put((WritableValue)entry.getKey(), ((JFXDrawerKeyValue)entry.getValue()).getOpenValueSupplier());
        }
        this.translateTo = 0.0;
        this.resizeTo = this.tempDrawerSize = this.getDefaultDrawerSize();
        this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
        this.translateTimer.setOnFinished(() -> this.fireEvent((Event)new JFXDrawerEvent(JFXDrawerEvent.OPENED)));
        this.getCachePolicy().cache((Node)this.contentHolder);
        this.translateTimer.start();
    }

    public <T> void addAnimatedKeyValue(Node node, JFXDrawerKeyValue ... values) {
        this.addAnimatedKeyValue(node, Arrays.asList(values));
    }

    public void addAnimatedKeyValue(Node node, List<JFXDrawerKeyValue<?>> values) {
        ArrayList<JFXKeyValue> modifiedValues = new ArrayList<JFXKeyValue>();
        for (JFXDrawerKeyValue<?> value : values) {
            JFXKeyValue modifiedValue = JFXKeyValue.builder().setEndValueSupplier(() -> ((Supplier)this.currentValue.get(value.getTarget())).get()).setAnimateCondition(() -> node.getScene() != null && value.isValid()).setTargetSupplier(() -> value.getTarget()).setInterpolator(value.getInterpolator()).build();
            modifiedValues.add(modifiedValue);
            this.currentValue.put(value.getTarget(), this.isClosed() ? value.getCloseValueSupplier() : value.getOpenValueSupplier());
            this.initValues.put(value.getTarget(), value);
        }
        this.animatedValues.addAll(modifiedValues);
        JFXKeyFrame keyFrame = new JFXKeyFrame(this.duration, modifiedValues.toArray(new JFXKeyValue[0]));
        try {
            this.translateTimer.addKeyFrame(keyFrame);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpeningProperty() {
        return this.onDrawerOpening;
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    static /* synthetic */ void access$000(CustomDrawer x0, EventType x1, EventHandler x2) {
        x0.setEventHandler(x1, x2);
    }

    static /* synthetic */ void access$100(CustomDrawer x0, EventType x1, EventHandler x2) {
        x0.setEventHandler(x1, x2);
    }

    static /* synthetic */ void access$200(CustomDrawer x0, EventType x1, EventHandler x2) {
        x0.setEventHandler(x1, x2);
    }

    static /* synthetic */ void access$300(CustomDrawer x0, EventType x1, EventHandler x2) {
        x0.setEventHandler(x1, x2);
    }
}

