/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceData;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentEvent;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.util.List;
import java.util.Optional;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import lombok.Generated;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowConfidenceSegment
extends AbstractSegment<LowConfidenceData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LowConfidenceSegment.class);
    public static final String TAG = "lct";
    public static final String CONFIDENCE_ATTRIBUTE = "conf";
    public static final String ALTERNATIVES_ATTRIBUTE = "alt";
    private boolean alternativesShown = false;
    private TextExt textNode;

    public LowConfidenceSegment(LowConfidenceData data) {
        super((Object)data);
    }

    public LowConfidenceSegment(LowConfidenceData data, boolean alternativesShown) {
        super((Object)data);
        this.alternativesShown = alternativesShown;
    }

    public Node createNode(TextStyle style) {
        this.textNode = new TextExt(this.getText());
        this.textNode.getStyleClass().add((Object)"styled-text-area-text");
        this.textNode.getStyleClass().add((Object)"lct-text");
        if (!this.alternativesShown) {
            this.textNode.getStyleClass().add((Object)"lct-text-new");
        } else {
            this.textNode.getStyleClass().add((Object)"lct-text-visited");
        }
        if (style != null && !style.toCss().isEmpty()) {
            this.textNode.setStyle(style.toCss());
        }
        Nodes.addInputMap((Node)this.textNode, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.PRIMARY), mouseEvent -> this.textNode.fireEvent((Event)new SegmentEvent(SegmentEvent.CLICKED, (AbstractSegment)this, mouseEvent.getClickCount())))}));
        return this.textNode;
    }

    public char charAt(int index) {
        return this.getText().charAt(index);
    }

    public String getText() {
        return ((LowConfidenceData)this.data).getWord();
    }

    public int length() {
        return this.getText().length();
    }

    public Optional<AbstractSegment<?>> subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return Optional.of(this);
        }
        return Optional.of(new StyledTextSegment((Object)this.getText().substring(start, end)));
    }

    public Optional<AbstractSegment<?>> join(AbstractSegment<?> nextSeg) {
        if (nextSeg instanceof LowConfidenceSegment) {
            return Optional.of(new StyledTextSegment((Object)(this.getText() + nextSeg.getText())));
        }
        return Optional.empty();
    }

    public float getConfidence() {
        return ((LowConfidenceData)this.data).getConfidence();
    }

    public List<String> getAlternatives() {
        return ((LowConfidenceData)this.data).getAlternatives();
    }

    public String getRealText() {
        return this.getText();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Generated
    public boolean isAlternativesShown() {
        return this.alternativesShown;
    }

    @Generated
    public TextExt getTextNode() {
        return this.textNode;
    }

    @Generated
    public void setAlternativesShown(boolean alternativesShown) {
        this.alternativesShown = alternativesShown;
    }
}

