/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentEvent;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.WordAlternativesPopup;
import jakarta.annotation.PostConstruct;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.collections.ObservableList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
class SegmentEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentEventHandler.class);
    private final WordAlternativesPopup wordAlternativesPopup;
    private final TranscriptTextArea transcriptTextArea;
    private final SpeakerService speakerService;

    @PostConstruct
    public void init() {
        this.transcriptTextArea.addEventHandler(SegmentEvent.CLICKED, event -> {
            AbstractSegment seg = event.getSegment();
            if (this.transcriptTextArea.getSelection().getLength() != 0) {
                return;
            }
            AbstractSegment abstractSegment = seg;
            Objects.requireNonNull(abstractSegment);
            AbstractSegment selector0$temp = abstractSegment;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LowConfidenceSegment.class, SpeakerSegment.class, TimestampSegment.class}, (AbstractSegment)selector0$temp, index$1)) {
                case 0: {
                    LowConfidenceSegment lcSeg = (LowConfidenceSegment)selector0$temp;
                    this.handleLowConfidenceClick(lcSeg, event.getClickCount());
                    break;
                }
                case 1: {
                    SpeakerSegment spSeg = (SpeakerSegment)selector0$temp;
                    this.handleSpeakerClick(spSeg);
                    break;
                }
                case 2: {
                    TimestampSegment tsSeg = (TimestampSegment)selector0$temp;
                    this.handleTimestampClick(tsSeg);
                    break;
                }
                default: {
                    log.debug("no specific handler for this segment type: {}", seg.getClass());
                }
            }
        });
    }

    private void handleLowConfidenceClick(LowConfidenceSegment seg, int clickCount) {
        if (clickCount == 1) {
            this.wordAlternativesPopup.addWordAlternativesToPopup(seg.getAlternatives());
            this.wordAlternativesPopup.show(seg);
            seg.setAlternativesShown(true);
            this.updateLctVisuals(seg);
        } else if (clickCount == 2) {
            int index = this.transcriptTextArea.findAbsolutePositionOfSegment((AbstractSegment)seg);
            this.transcriptTextArea.selectRange(index, index + seg.length());
        }
    }

    private void handleSpeakerClick(SpeakerSegment seg) {
        this.speakerService.showSpeakerPopup(seg);
    }

    private void handleTimestampClick(TimestampSegment seg) {
        log.debug("Clicked on timestamp, ms: {}", (Object)seg.getMillis());
        Main.getPlayer().setTime(seg.getMillis());
        Main.getPlayer().play();
    }

    private void updateLctVisuals(LowConfidenceSegment seg) {
        if (seg.getTextNode() != null) {
            ObservableList classes = seg.getTextNode().getStyleClass();
            classes.remove((Object)"lct-text-new");
            if (!classes.contains((Object)"lct-text-visited")) {
                classes.add((Object)"lct-text-visited");
            }
        }
    }

    @Generated
    public SegmentEventHandler(WordAlternativesPopup wordAlternativesPopup, TranscriptTextArea transcriptTextArea, SpeakerService speakerService) {
        this.wordAlternativesPopup = wordAlternativesPopup;
        this.transcriptTextArea = transcriptTextArea;
        this.speakerService = speakerService;
    }
}

