/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentEvent;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.util.Objects;
import java.util.UUID;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import lombok.Generated;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeakerSegment
extends AbstractSegment<Object>
implements HasPreDefinedStyle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerSegment.class);
    public static final String TAG = "Speaker";
    public static final String UUID_ATTRIBUTE = "uuid";
    private String text = "";
    private String uuid = "";
    private Label item;
    private final TextStyle speakerTextStyle;

    public SpeakerSegment(Object data, String speakerName, TextStyle speakerTextStyle) {
        super(data);
        this.speakerTextStyle = speakerTextStyle;
        String string = this.text = speakerName != null ? speakerName : "Unbekannt";
        if (data instanceof UUID) {
            this.uuid = data.toString();
        } else if (data instanceof String) {
            String string2;
            this.uuid = string2 = (String)data;
        }
    }

    public Node createNode(TextStyle style) {
        this.item = new Label(this.text);
        Nodes.addInputMap((Node)this.item, (InputMap)InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.PRIMARY), e -> this.item.fireEvent((Event)new SegmentEvent(SegmentEvent.CLICKED, (AbstractSegment)this, e.getClickCount()))));
        this.item.getStyleClass().add((Object)"speaker");
        this.updateStyle(this.speakerTextStyle);
        this.item.setUserData(this.getData());
        return this.item;
    }

    public void updateStyle(TextStyle newStyle) {
        if (this.item != null) {
            this.item.setStyle(newStyle.toCss());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpeakerSegment)) {
            return false;
        }
        SpeakerSegment that = (SpeakerSegment)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return "SpeakerSegment{uuid='" + this.uuid + "'}";
    }

    public Label getLabel() {
        return this.item;
    }

    public String getRealText() {
        return this.text + " ";
    }

    public TextStyle getTextStyle() {
        return this.speakerTextStyle;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Label getItem() {
        return this.item;
    }
}

