/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.util.Optional;
import javafx.scene.Node;
import org.fxmisc.richtext.TextExt;

public class StyledTextSegment
extends AbstractSegment<Object> {
    public static final String TAG = "StyledText";
    protected final String text;

    public StyledTextSegment(Object text) {
        super(text);
        this.text = text.toString();
    }

    public Node createNode(TextStyle style) {
        TextExt textNode = new TextExt(this.text);
        textNode.getStyleClass().add((Object)"styled-text-area-text");
        if (style != null && !style.toCss().isEmpty()) {
            textNode.setStyle(style.toCss());
        }
        return textNode;
    }

    public char charAt(int index) {
        return this.text.charAt(index);
    }

    public String getText() {
        return this.text;
    }

    public int length() {
        return this.text.length();
    }

    public Optional<AbstractSegment<?>> subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return Optional.of(this);
        }
        return Optional.of(new StyledTextSegment((Object)this.text.substring(start, end)));
    }

    public Optional<AbstractSegment<?>> join(AbstractSegment<?> nextSeg) {
        if (nextSeg instanceof StyledTextSegment) {
            return Optional.of(new StyledTextSegment((Object)(this.text + nextSeg.getText())));
        }
        return Optional.empty();
    }

    public String getRealText() {
        return this.getText();
    }
}

