/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textformattingcontrol;

import com.jfoenix.controls.JFXComboBox;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.CustomJFXComboBox;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textformattingcontrol.TextFormattingService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@FxmlView(value="textFormatting.fxml")
public class TextFormattingController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextFormattingController.class);
    private final TextFormattingService formattingService;
    private final MessageService messageService;
    private final SimpleBooleanProperty hideAlignment = new SimpleBooleanProperty(false);
    @FXML
    private CustomJFXComboBox<String> textFontComboBox;
    @FXML
    private CustomJFXComboBox<String> textFontSizeComboBox;
    @FXML
    private ToggleButton textBoldToggleButton;
    @FXML
    private ToggleButton textItalicToggleButton;
    @FXML
    private ToggleButton textUnderlineToggleButton;
    @FXML
    private HBox textOrientationHBox;
    @FXML
    private ToggleButton textLeftToRightToggleButton;
    @FXML
    private ToggleButton textCenterToggleButton;
    @FXML
    private ToggleButton textJustifyToggleButton;
    @FXML
    private ToggleButton textRightToLeftToggleButton;
    @FXML
    private VBox root;
    private ToggleGroup textOrientationToggleGroup;

    @FXML
    public void initialize() {
        this.textOrientationToggleGroup = new ToggleGroup();
        this.textOrientationToggleGroup.getToggles().addAll((Object[])new Toggle[]{this.textLeftToRightToggleButton, this.textRightToLeftToggleButton, this.textCenterToggleButton, this.textJustifyToggleButton});
        this.textOrientationToggleGroup.selectToggle((Toggle)this.textLeftToRightToggleButton);
        this.textOrientationToggleGroup.selectedToggleProperty().addListener((obsVal, oldVal, newVal) -> {
            if (newVal == null && oldVal != null) {
                oldVal.setSelected(true);
            }
        });
        this.textOrientationHBox.managedProperty().bind((ObservableValue)this.hideAlignment.not());
        this.textOrientationHBox.visibleProperty().bind((ObservableValue)this.hideAlignment.not());
        ObservableList fonts = FXCollections.observableList((List)Utils.getFontFamilies());
        this.textFontComboBox.getItems().addAll((Collection)fonts);
        this.textFontSizeComboBox.getItems().addAll(Utils.getFontSizes().stream().map(String::valueOf).toList());
        this.formattingService.addAutoCompletePopup((JFXComboBox)this.textFontComboBox);
        this.textFontComboBox.getEditor().focusedProperty().addListener((observableValue, aBoolean, t1) -> {
            if (!t1.booleanValue()) {
                this.ensureSetFontExists();
            }
        });
    }

    public void ensureSetFontExists() {
        String font = this.textFontComboBox.getEditor().getText();
        ResourceBundle bundle = this.messageService.getLocaleBundle();
        if (this.formattingService.isSelectionActive() && font.equals(bundle.getString("drawer.fontsMixed"))) {
            return;
        }
        if (!this.textFontComboBox.getItems().contains((Object)font)) {
            if (this.textFontComboBox.getItems().contains((Object)"Monospaced")) {
                this.textFontComboBox.setValue((Object)"Monospaced");
            } else if (this.textFontComboBox.getItems().contains((Object)"Arial")) {
                this.textFontComboBox.setValue((Object)"Arial");
            } else {
                this.textFontComboBox.setValue((Object)((String)this.textFontComboBox.getItems().getFirst()));
            }
        }
    }

    public void setHideAlignment(boolean hide) {
        this.hideAlignment.set(hide);
    }

    public boolean isHideAlignment() {
        return this.hideAlignment.get();
    }

    public int getFontSizeValue() {
        String value = (String)this.textFontSizeComboBox.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 12;
        }
    }

    public void setFontSizeValue(int number) {
        this.textFontSizeComboBox.setValue((Object)String.valueOf(number));
    }

    @Generated
    public TextFormattingService getFormattingService() {
        return this.formattingService;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public SimpleBooleanProperty getHideAlignment() {
        return this.hideAlignment;
    }

    @Generated
    public CustomJFXComboBox<String> getTextFontComboBox() {
        return this.textFontComboBox;
    }

    @Generated
    public CustomJFXComboBox<String> getTextFontSizeComboBox() {
        return this.textFontSizeComboBox;
    }

    @Generated
    public ToggleButton getTextBoldToggleButton() {
        return this.textBoldToggleButton;
    }

    @Generated
    public ToggleButton getTextItalicToggleButton() {
        return this.textItalicToggleButton;
    }

    @Generated
    public ToggleButton getTextUnderlineToggleButton() {
        return this.textUnderlineToggleButton;
    }

    @Generated
    public HBox getTextOrientationHBox() {
        return this.textOrientationHBox;
    }

    @Generated
    public ToggleButton getTextLeftToRightToggleButton() {
        return this.textLeftToRightToggleButton;
    }

    @Generated
    public ToggleButton getTextCenterToggleButton() {
        return this.textCenterToggleButton;
    }

    @Generated
    public ToggleButton getTextJustifyToggleButton() {
        return this.textJustifyToggleButton;
    }

    @Generated
    public ToggleButton getTextRightToLeftToggleButton() {
        return this.textRightToLeftToggleButton;
    }

    @Generated
    public VBox getRoot() {
        return this.root;
    }

    @Generated
    public ToggleGroup getTextOrientationToggleGroup() {
        return this.textOrientationToggleGroup;
    }

    @Generated
    public TextFormattingController(TextFormattingService formattingService, MessageService messageService) {
        this.formattingService = formattingService;
        this.messageService = messageService;
    }
}

