/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textformattingcontrol;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXComboBox;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TextFormattingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextFormattingService.class);
    private final TranscriptTextArea transcriptTextArea;

    public boolean isSelectionActive() {
        return this.transcriptTextArea.getSelection().getLength() > 0;
    }

    public <T> JFXAutoCompletePopup<T> addAutoCompletePopup(JFXComboBox<T> combobox) {
        JFXAutoCompletePopup autoCompletePopup = new JFXAutoCompletePopup();
        autoCompletePopup.setFixedCellSize(36.0);
        autoCompletePopup.getSuggestions().addAll((Collection)combobox.getItems());
        autoCompletePopup.setSelectionHandler(event -> combobox.setValue(event.getObject()));
        TextField editor = combobox.getEditor();
        editor.addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.ESCAPE || event.getCode() == KeyCode.ENTER) {
                event.consume();
            } else if (!event.getCode().isArrowKey() && !editor.getText().isEmpty()) {
                autoCompletePopup.filter(item -> item.toString().toLowerCase().contains(editor.getText().toLowerCase()));
                if (autoCompletePopup.getFilteredSuggestions().isEmpty()) {
                    autoCompletePopup.hide();
                } else {
                    autoCompletePopup.show((Node)editor);
                    combobox.hide();
                }
            }
        });
        combobox.showingProperty().addListener((observableValue, aBoolean, t1) -> {
            if (t1.booleanValue()) {
                autoCompletePopup.hide();
            }
        });
        return autoCompletePopup;
    }

    @Generated
    public TextFormattingService(TranscriptTextArea transcriptTextArea) {
        this.transcriptTextArea = transcriptTextArea;
    }
}

