/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.AutoCompletionService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.io.DocumentDeserializer;
import eu.ewerkzeug.easytranscript3.commons.io.ZipService;
import eu.ewerkzeug.easytranscript3.commons.io.importers.ETPMigrator;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.migrations.MigrationService;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.mvc.main.MiscService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component
public class LoadTranscriptService
extends Service<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadTranscriptService.class);
    private final StatusService statusService;
    private final MigrationService migrationService;
    private final ZipService zipService;
    private final AutoCompletionService autoCompletionService;
    private final MiscService miscService;
    private final TextAreaService textAreaService;
    private final CloseDialog closeDialog;
    private final ETPMigrator etpMigrator;
    private final TranscriptTextArea transcriptTextArea;
    private final ConfigurationService configurationService;
    private final LicenseValidationService licenseValidationService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final TranscriptService transcriptService;
    private final DocumentDeserializer documentDeserializer;
    private final ExceptionAlert exceptionAlert;
    private final GuiStateService guiStateService;
    private Path pathToLoadFrom;

    @PostConstruct
    public void setup() {
        this.setOnFailed(workerStateEvent -> log.error("LoadTranscriptService has failed.", this.getException()));
        this.setOnSucceeded(workerStateEvent -> {
            boolean isSaved = true;
            if (this.configurationService.getConfiguration().isAutoRecoverActive() && this.licenseValidationService.isUserLicenseValid()) {
                this.suggestLoadingOfAutoRecover();
                if (this.statusService.isRecovered()) {
                    isSaved = false;
                }
            }
            this.statusService.setSaved(isSaved);
        });
    }

    public void openTranscriptWithFileChooser() {
        this.closeDialog.showAndWait(() -> {
            FileChooser fileChooser = new FileChooser();
            if (Main.getRecentOpenedFileChooserPath() != null) {
                fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
            }
            fileChooser.getExtensionFilters().addAll((Collection)this.transcriptService.getTranscriptExtensionFilters());
            File file = fileChooser.showOpenDialog((Window)this.guiStateService.getMainStage());
            if (file != null) {
                this.pathToLoadFrom = file.toPath();
                this.restart();
            }
        });
    }

    public void openTranscript(Path transcript) {
        this.pathToLoadFrom = transcript;
        this.restart();
    }

    private void open(Path transcript) {
        log.debug("Going to load Transcript...");
        if (this.statusService.isTranscriptLoading()) {
            log.warn("Transcript already loading.");
            return;
        }
        this.statusService.setLoadingProgress(0);
        this.statusService.setTranscriptLoading(true);
        this.transcriptService.getCurrentTranscript().getSubscriptions().forEach(Subscription::unsubscribe);
        Platform.runLater(() -> ((TranscriptTextArea)this.transcriptTextArea).clear());
        this.statusService.setLoadingProgress(5);
        try {
            this.transcriptService.setCurrentTranscript(this.loadTranscriptAndMigrate(transcript));
            this.transcriptService.updateSpeakerTextStyle(this.transcriptService.getCurrentTranscript());
        }
        catch (IOException ex) {
            this.handleFailedToLoad(transcript, (Exception)ex);
            return;
        }
        this.configurationService.getConfiguration().addToRecentLoaded(this.transcriptService.getCurrentTranscript());
        this.configurationService.save();
        log.debug("Media needs to be reloaded. Is: {}", (Object)this.statusService.isMediaNeedsReload());
        this.statusService.setMediaNeedsReload(true);
        this.statusService.setSaved(true);
        this.statusService.setLoadingProgress(70);
        AtomicBoolean failed = new AtomicBoolean(false);
        try {
            ReadOnlyStyledDocument doc = this.documentDeserializer.deserialize(this.transcriptService.getCurrentTranscript().getDocument());
            Platform.runLater(() -> {
                this.transcriptTextArea.replace((StyledDocument)doc);
                this.transcriptTextArea.getUndoManager().forgetHistory();
                this.transcriptTextArea.moveTo(0);
                FxTimer.runLater((Duration)Duration.of(100L, ChronoUnit.MILLIS), () -> this.transcriptTextArea.getVsPane().scrollYBy(-200.0));
            });
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Platform.runLater(() -> this.handleFailedToLoad(transcript, ex));
            failed.set(true);
        }
        if (failed.get()) {
            return;
        }
        this.statusService.setLoadingProgress(90);
        this.doPostLoadingSteps();
        this.statusService.setLoadingProgress(100);
        Platform.runLater(() -> {
            this.statusService.setTranscriptLoading(false);
            this.statusService.setTranscriptLoaded(true);
        });
        log.info("Opened Transcript {}", (Object)this.transcriptService.getCurrentTranscript().getUuid());
    }

    private void handleFailedToLoad(Path transcript, Exception ex) {
        log.error("", (Throwable)ex);
        this.statusService.setTranscriptLoading(false);
        this.statusService.setTranscriptLoaded(false);
        this.exceptionAlert.showModal();
        log.error(ex.getLocalizedMessage(), (Throwable)ex);
        this.configurationService.getConfiguration().getProgramRecentLoadedObservableList().remove((Object)transcript.toString());
        this.configurationService.save();
        Platform.runLater(() -> ((MiscService)this.miscService).closeTranscript());
    }

    public Transcript loadTranscriptAndMigrate(Path transcriptPath) throws IOException {
        Transcript transcript;
        log.debug("Loading transcript from path {}", (Object)transcriptPath);
        boolean etpMigratedToEtt = false;
        UUID unzipUUID = UUID.randomUUID();
        if (this.zipService.isZipFile(transcriptPath)) {
            this.zipService.unzipFile(transcriptPath, this.transcriptService.getTemporaryTranscriptLocation(unzipUUID.toString()));
            this.statusService.setLoadingProgress(25);
            transcript = this.transcriptService.loadProperties(unzipUUID.toString(), transcriptPath);
            this.statusService.setLoadingProgress(30);
            String document = this.transcriptService.loadDocument(transcript);
            if (document != null) {
                transcript.setDocument(document);
            }
        } else {
            if (transcriptPath.toString().endsWith(".etp")) {
                transcript = this.etpMigrator.migrate(transcriptPath);
                etpMigratedToEtt = true;
            } else {
                transcript = this.transcriptService.loadProperties(transcriptPath, unzipUUID.toString(), transcriptPath);
                transcript.setUsedETVersion(Version.parse((String)"3.0.0-BETA.16"));
            }
            log.warn("This transcript is not a zip file.");
        }
        this.statusService.setLoadingProgress(35);
        boolean migrationsApplied = this.migrationService.applyTranscriptMigrations(transcript);
        this.statusService.setTranscriptWasMigrated(migrationsApplied || etpMigratedToEtt);
        this.statusService.setLoadingProgress(55);
        return transcript;
    }

    private void doPostLoadingSteps() {
        this.transcriptService.getCurrentTranscript().getSubscriptions().add(EventStreams.changesOf((ObservableValue)this.statusService.savedProperty()).subscribe(event -> Platform.runLater(() -> ((MiscService)this.miscService).setTitle())));
        this.transcriptService.getCurrentTranscript().getSubscriptions().add(EventStreams.changesOf((ObservableValue)this.statusService.recoveredProperty()).subscribe(event -> Platform.runLater(() -> ((MiscService)this.miscService).setTitle())));
        this.transcriptService.getCurrentTranscript().getSubscriptions().add(EventStreams.changesOf((ObservableValue)this.statusService.keyCombinationNeedReloadProperty()).subscribe(event -> {
            if (Boolean.TRUE.equals(event.getNewValue())) {
                this.textAreaService.registerTranscriptKeyCombinationSubstitution();
            }
            log.debug("Transcript keycombinations have changed.");
            this.statusService.setKeyCombinationNeedReload(false);
        }));
        this.transcriptService.getCurrentTranscript().setHash(DigestUtils.sha256Hex((String)this.transcriptService.getCurrentTranscript().getDocument()));
        this.statusService.setLoadingProgress(95);
        Platform.runLater(() -> ((AutoCompletionService)this.autoCompletionService).restart());
        this.textAreaService.registerTranscriptKeyCombinationSubstitution();
        Main.setRecentOpenedFileChooserPath((File)this.transcriptService.getCurrentTranscript().getTranscriptLocation().getParent().toFile());
        Platform.runLater(() -> ((MiscService)this.miscService).setTitle());
    }

    private void suggestLoadingOfAutoRecover() {
        Path autoRecoverPath = Path.of(Configuration.ET_HOME + "/backups/" + this.transcriptService.getCurrentTranscript().getUuid() + ".ett", new String[0]);
        Path transcriptPath = this.transcriptService.getCurrentTranscript().getTranscriptLocation();
        if (!Files.exists(autoRecoverPath, new LinkOption[0])) {
            return;
        }
        try {
            FileTime lastModifiedTimeLoaded = Files.getLastModifiedTime(transcriptPath, new LinkOption[0]);
            FileTime lastModifiedTimeAutoRecover = Files.getLastModifiedTime(autoRecoverPath, new LinkOption[0]);
            if (lastModifiedTimeAutoRecover.compareTo(lastModifiedTimeLoaded) <= 0) {
                log.debug("Deleted old auto recover.");
                Files.delete(autoRecoverPath);
                return;
            }
            log.debug("Found newer autorecover.");
            ETButtonType yes = new ETButtonType(ButtonType.YES, true, false);
            ETButtonType no = new ETButtonType(ButtonType.NO, false, false);
            ETDialog alert = this.dialogService.createDialog("", this.messageService.getLocaleBundle().getString("problems.newerAutoRecover"), Modality.WINDOW_MODAL, List.of(yes, no));
            AtomicReference result = new AtomicReference();
            Platform.runLater(() -> result.set(alert.showAndWait()));
            if (result.get() != null && result.get() == ButtonType.YES) {
                log.info("Replacing transcript by autorecover.");
                String unzipUuid = this.transcriptService.getCurrentTranscript().getUnzipUuid();
                this.transcriptService.setCurrentTranscript(this.loadTranscriptAndMigrate(autoRecoverPath));
                this.transcriptService.getCurrentTranscript().setUnzipUuid(unzipUuid);
                this.transcriptService.getCurrentTranscript().setTranscriptLocation(transcriptPath);
                this.statusService.setRecovered(true);
            }
        }
        catch (IOException e) {
            log.error("could not load Autorecover.", (Throwable)e);
            this.statusService.setTranscriptLoading(false);
            this.statusService.setTranscriptLoaded(false);
            this.exceptionAlert.showModal();
        }
    }

    protected Task<Void> createTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Generated
    public LoadTranscriptService(StatusService statusService, MigrationService migrationService, ZipService zipService, AutoCompletionService autoCompletionService, MiscService miscService, TextAreaService textAreaService, CloseDialog closeDialog, ETPMigrator etpMigrator, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, LicenseValidationService licenseValidationService, MessageService messageService, DialogService dialogService, TranscriptService transcriptService, DocumentDeserializer documentDeserializer, ExceptionAlert exceptionAlert, GuiStateService guiStateService) {
        this.statusService = statusService;
        this.migrationService = migrationService;
        this.zipService = zipService;
        this.autoCompletionService = autoCompletionService;
        this.miscService = miscService;
        this.textAreaService = textAreaService;
        this.closeDialog = closeDialog;
        this.etpMigrator = etpMigrator;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.licenseValidationService = licenseValidationService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.transcriptService = transcriptService;
        this.documentDeserializer = documentDeserializer;
        this.exceptionAlert = exceptionAlert;
        this.guiStateService = guiStateService;
    }

    @Generated
    public Path getPathToLoadFrom() {
        return this.pathToLoadFrom;
    }

    @Generated
    public void setPathToLoadFrom(Path pathToLoadFrom) {
        this.pathToLoadFrom = pathToLoadFrom;
    }
}

