/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class XmlSanitizer {
    private final Pattern illegalXmlChars = Pattern.compile("[^\t\r\n -\ud7ff\ue000-\ufffd]");
    private final Pattern illegalEntities = Pattern.compile("&#(?:x[0-1]?[0-9a-fA-F]|0?(?:[0-8]|1[12]|1[4-9]|2[0-9]|3[01]));?");

    public String sanitize(String xml) {
        if (xml == null) {
            return null;
        }
        String cleaned = this.illegalXmlChars.matcher(xml).replaceAll("");
        return this.illegalEntities.matcher(cleaned).replaceAll("");
    }
}

