/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
@Lazy
public class DOCXExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DOCXExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Word Document (*.docx)", new String[]{"*.docx"});
    private final ConfigurationService configurationService;

    public DOCXExporter(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a docx file...");
        try (XWPFDocument doc = new XWPFDocument();){
            log.debug("Processing paragraphs of document...");
            int i = 0;
            for (Paragraph documentParagraph : document.getParagraphs()) {
                log.debug("Processing paragraph {} of {}", (Object)i, (Object)document.getParagraphs().size());
                XWPFParagraph paragraph = doc.createParagraph();
                int j = 0;
                for (StyledSegment styledSegment : documentParagraph.getStyledSegments()) {
                    TextStyle style;
                    log.debug("Processing text segment {} of {}", (Object)j, (Object)documentParagraph.getStyledSegments().size());
                    XWPFRun run = paragraph.createRun();
                    Object object = styledSegment.getSegment();
                    if (object instanceof HasPreDefinedStyle) {
                        HasPreDefinedStyle hasPreDefinedStyle = (HasPreDefinedStyle)object;
                        style = hasPreDefinedStyle.getTextStyle();
                    } else {
                        style = (TextStyle)styledSegment.getStyle();
                    }
                    run.setText(((AbstractSegment)styledSegment.getSegment()).getRealText());
                    run.setFontSize(style.fontSizeOptional.orElse(this.configurationService.getConfiguration().getFormattingSize()).intValue());
                    run.setFontFamily(style.fontFamilyOptional.orElse(this.configurationService.getConfiguration().getFormattingFont()).replace("\"", ""));
                    run.setBold(style.boldOptional.orElse(false).booleanValue());
                    run.setItalic(style.italicOptional.orElse(false).booleanValue());
                    if (style.underlineOptional.isPresent() && Boolean.TRUE.equals(style.underlineOptional.get())) {
                        run.setUnderline(UnderlinePatterns.SINGLE);
                    } else {
                        run.setUnderline(UnderlinePatterns.NONE);
                    }
                    ++j;
                }
                ++i;
            }
            log.debug("Processed document. Writing to disk ...");
            this.writeDocument(out, doc);
            log.info("Exported document as docx file.");
        }
        catch (Exception e) {
            log.info("Failed to create new docx document.", (Throwable)e);
            throw e;
        }
    }

    private void writeDocument(Path out, XWPFDocument doc) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(out.toString());){
            doc.write((OutputStream)fos);
        }
        catch (Exception e) {
            log.info("Failed to write file.", (Throwable)e);
            throw e;
        }
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }
}

