/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.Exporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.TableExporter;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class ExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    private final List<DocumentExporter> documentExporters;
    private final List<TableExporter> tableExporters;
    private final LicenseService licenseService;
    private final FileChooser fileChooser = new FileChooser();
    private final LicenseValidationService licenseValidationService;
    private final DialogService dialogService;
    private final MessageService messageService;
    private final ExceptionAlert exceptionAlert;
    private final GuiStateService guiStateService;

    @Autowired
    public ExportService(List<DocumentExporter> documentExporters, List<TableExporter> tableExporters, LicenseService licenseService, LicenseValidationService licenseValidationService, DialogService dialogService, MessageService messageService, ExceptionAlert exceptionAlert, GuiStateService guiStateService) {
        this.documentExporters = documentExporters;
        this.tableExporters = tableExporters;
        this.licenseService = licenseService;
        this.licenseValidationService = licenseValidationService;
        this.dialogService = dialogService;
        this.messageService = messageService;
        this.exceptionAlert = exceptionAlert;
        this.guiStateService = guiStateService;
    }

    public void showExportDialog(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document) {
        this.prepareExportDialog(document, this.documentExporters.stream().map(Exporter::getFilter).toList(), this.documentExporters);
    }

    public void showExportDialog(List<TimeTrackingEntry> document) {
        this.prepareExportDialog(document, this.tableExporters.stream().map(Exporter::getFilter).toList(), this.tableExporters);
    }

    private void prepareExportDialog(Object document, List<FileChooser.ExtensionFilter> filters, List<? extends Exporter<?>> exporters) {
        log.debug("Preparing export dialog...");
        log.debug("Filters: {}", filters.stream().map(FileChooser.ExtensionFilter::getExtensions).toList());
        if (!this.licenseValidationService.isUserLicenseValid()) {
            log.warn("License is not valid anymore.");
            this.licenseService.showLicenseNotValidDialog();
            return;
        }
        log.debug("Opening file chooser...");
        if (Main.getRecentOpenedFileChooserPath() != null) {
            this.fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        this.fileChooser.getExtensionFilters().clear();
        this.fileChooser.getExtensionFilters().addAll(filters);
        File file = this.fileChooser.showSaveDialog((Window)this.guiStateService.getController().getStage());
        if (file != null) {
            log.debug("File selected. Exporting...");
            this.export(exporters, file, document);
            Main.setRecentOpenedFileChooserPath((File)file.getParentFile());
            log.info("File exported.");
        }
    }

    private void export(List<? extends Exporter> exporters, File file, Object document) {
        log.debug("Exporting with Exporters: {}", exporters.stream().map(f -> f.getClass().getSimpleName()).toList());
        if (file == null) {
            log.debug("No file selected.");
            return;
        }
        try {
            for (Exporter exporter : exporters) {
                if (!((String)exporter.getFilter().getExtensions().getFirst()).equals(this.fileChooser.getSelectedExtensionFilter().getExtensions().getFirst())) continue;
                this.tryToExport(file, document, exporter);
            }
        }
        catch (FileNotFoundException e) {
            log.error("", (Throwable)e);
            this.showProblem("problems.cannotCreateOrOpen", e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            log.error("", (Throwable)e);
            this.showProblem("problems.cannotWrite", e.getLocalizedMessage());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            this.showProblem("problems.genericIOError", e.getLocalizedMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
        }
    }

    private void tryToExport(File file, Object document, Exporter<Object> exporter) throws Exception {
        try {
            exporter.export(document, file.toPath());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            log.warn("Importer does not support class of document: {}", document.getClass(), (Object)e);
        }
    }

    private void showProblem(String s, String localizedMessage) {
        this.dialogService.get(this.messageService.getLocaleBundle().getString(s) + "\n\n" + this.messageService.getLocaleBundle().getString("general.error") + ": " + localizedMessage, Alert.AlertType.ERROR).showAndWait();
    }
}

