/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
@Lazy
public class HTMLExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTMLExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("HTML (*.html)", new String[]{"*.html"});
    private final TranscriptTextArea transcriptTextArea;
    private final TranscriptService transcriptService;

    public HTMLExporter(TranscriptTextArea transcriptTextArea, TranscriptService transcriptService) {
        this.transcriptTextArea = transcriptTextArea;
        this.transcriptService = transcriptService;
    }

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a html file...");
        String content = this.transcriptService.documentToHtml(this.transcriptService.getCurrentTranscript(), this.transcriptTextArea.getDocument());
        Files.write(out, List.of(content), new OpenOption[0]);
        log.info("Exported document a html document.");
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

