/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.ODTExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTextProperties;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
@Lazy
public class ODTExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODTExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("OpenDocument Text (*.odt)", new String[]{"*.odt"});
    private final ConfigurationService configurationService;

    public ODTExporter(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a odt file...");
        OdfTextDocument odtDoc = OdfTextDocument.newTextDocument();
        OfficeTextElement officeText = odtDoc.getContentRoot();
        officeText.setNodeValue("");
        HashMap styleCache = new HashMap();
        log.debug("Processing paragraphs of document...");
        int i = 0;
        for (Paragraph documentParagraph : document.getParagraphs()) {
            log.debug("Processing paragraph {} of {}", (Object)(++i), (Object)document.getParagraphs().size());
            TextPElement pElement = officeText.newTextPElement();
            int j = 0;
            for (StyledSegment styledSegment : documentParagraph.getStyledSegments()) {
                TextStyle textStyle;
                log.debug("Processing text segment {} of {}", (Object)(++j), (Object)documentParagraph.getStyledSegments().size());
                Object object = styledSegment.getSegment();
                if (object instanceof HasPreDefinedStyle) {
                    HasPreDefinedStyle hasStyle = (HasPreDefinedStyle)object;
                    textStyle = hasStyle.getTextStyle();
                } else {
                    textStyle = (TextStyle)styledSegment.getStyle();
                }
                TextStyle style = textStyle;
                TextSpanElement spanElement = pElement.newTextSpanElement();
                spanElement.setTextContent(((AbstractSegment)styledSegment.getSegment()).getRealText());
                String styleName = this.getOrCreateStyle(odtDoc, styleCache, style);
                spanElement.setStyleName(styleName);
            }
        }
        odtDoc.save(out.toFile());
        log.info("Exported document as ODT file successfully.");
    }

    private String getOrCreateStyle(OdfTextDocument doc, Map<StyleKey, String> cache, TextStyle style) {
        String font = style.fontFamilyOptional.orElse(this.configurationService.getConfiguration().getFormattingFont()).replace("\"", "");
        double size = style.fontSizeOptional.orElse(12).intValue();
        boolean bold = style.boldOptional.orElse(false);
        boolean italic = style.italicOptional.orElse(false);
        boolean underline = style.underlineOptional.orElse(false);
        StyleKey key = new StyleKey(font, size, bold, italic, underline);
        return cache.computeIfAbsent(key, k -> {
            String newName = "S_" + cache.size();
            try {
                OdfStyle odfStyle = doc.getContentDom().getOrCreateAutomaticStyles().newStyle(OdfStyleFamily.Text);
                odfStyle.setStyleNameAttribute(newName);
                odfStyle.setProperty(OdfTextProperties.FontFamily, k.font());
                odfStyle.setProperty(OdfTextProperties.FontSize, k.size() + "pt");
                if (k.bold()) {
                    odfStyle.setProperty(OdfTextProperties.FontWeight, "bold");
                }
                if (k.italic()) {
                    odfStyle.setProperty(OdfTextProperties.FontStyle, "italic");
                }
                if (k.underline()) {
                    odfStyle.setProperty(OdfTextProperties.TextUnderlineStyle, "solid");
                    odfStyle.setProperty(OdfTextProperties.TextUnderlineWidth, "auto");
                    odfStyle.setProperty(OdfTextProperties.TextUnderlineColor, "font-color");
                }
            }
            catch (Exception e) {
                log.error("Failed to create ODF style", (Throwable)e);
            }
            return newName;
        });
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

