/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfHeader;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfText;
import com.tutego.jrtf.RtfTextPara;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
@Lazy
public class RTFExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RTFExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Rich-Text-Format (*.rtf)", new String[]{"*.rtf"});
    private final ConfigurationService configurationService;

    public RTFExporter(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a rtf file...");
        log.debug("Processing paragraphs of document...");
        int i = 0;
        Rtf rtf = Rtf.rtf();
        ArrayList fontNames = new ArrayList();
        ArrayList<RtfTextPara> paragraphs = new ArrayList<RtfTextPara>();
        for (Paragraph documentParagraph : document.getParagraphs()) {
            log.debug("Processing paragraph {} of {}", (Object)i, (Object)(document.getParagraphs().size() - 1));
            List textSegments = this.processParagraph(fontNames, documentParagraph);
            paragraphs.add(RtfPara.p((RtfText[])textSegments.toArray(new RtfText[0])));
            ++i;
        }
        ArrayList<RtfHeader> headerFonts = new ArrayList<RtfHeader>();
        for (int i1 = 0; i1 < fontNames.size(); ++i1) {
            headerFonts.add(RtfHeader.font((String)((String)fontNames.get(i1))).at(i1));
        }
        rtf = rtf.header(headerFonts.toArray(new RtfHeader[0])).section(paragraphs.toArray(new RtfPara[0]));
        log.debug("Processed document. Writing to disk ...");
        try (FileWriter outputStream = new FileWriter(out.toFile());){
            rtf.out((Appendable)outputStream);
        }
        catch (Exception e) {
            log.error("Failed to write rtf to disk.", (Throwable)e);
            throw e;
        }
        log.info("Exported document as rtf file.");
    }

    @NotNull
    private List<RtfText> processParagraph(ArrayList<String> fontNames, Paragraph<ParStyle, AbstractSegment<?>, TextStyle> documentParagraph) {
        int j = 0;
        ArrayList<RtfText> textSegments = new ArrayList<RtfText>();
        for (StyledSegment styledSegment : documentParagraph.getStyledSegments()) {
            log.debug("Processing text segment {} of {}", (Object)j, (Object)(documentParagraph.getStyledSegments().size() - 1));
            RtfText rtfText = this.processSegment(fontNames, styledSegment);
            textSegments.add(rtfText);
            ++j;
        }
        return textSegments;
    }

    private RtfText processSegment(ArrayList<String> fontNames, StyledSegment<AbstractSegment<?>, TextStyle> styledSegment) {
        AbstractSegment segment = (AbstractSegment)styledSegment.getSegment();
        boolean bold = ((TextStyle)styledSegment.getStyle()).boldOptional.orElse(false);
        boolean italic = ((TextStyle)styledSegment.getStyle()).italicOptional.orElse(false);
        boolean underlined = ((TextStyle)styledSegment.getStyle()).underlineOptional.orElse(false);
        int fontSize = ((TextStyle)styledSegment.getStyle()).fontSizeOptional.orElse(this.configurationService.getConfiguration().getFormattingSize()) * 2;
        String fontFamily = ((TextStyle)styledSegment.getStyle()).fontFamilyOptional.orElse(this.configurationService.getConfiguration().getFormattingFont());
        if (!fontNames.contains(fontFamily = fontFamily.replace("\"", ""))) {
            fontNames.add(fontFamily);
        }
        int fontIndex = fontNames.indexOf(fontFamily);
        RtfText rtfText = RtfText.text((String)segment.getRealText());
        if (bold) {
            rtfText = RtfText.bold((Object)rtfText);
        }
        if (italic) {
            rtfText = RtfText.italic((Object)rtfText);
        }
        if (underlined) {
            rtfText = RtfText.underline((Object)rtfText);
        }
        rtfText = RtfText.fontSize((int)fontSize, (Object)rtfText);
        rtfText = RtfText.font((int)fontIndex, (Object)rtfText);
        return rtfText;
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

