/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.SRTExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Order(value=4)
@Lazy
public class SRTExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SRTExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("SRT (*.srt)", new String[]{"*.srt"});
    private final DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm:ss,SS").withZone(ZoneOffset.UTC);

    private static void fixStart(SRTSubtitle current, List<SRTSubtitle> subtitles) {
        if (current.getStart() == null) {
            log.debug("No start found. Setting to previous.");
            if (!subtitles.isEmpty()) {
                current.setStart(subtitles.getLast().getEnd());
            } else {
                current.setStart(new Date(0L));
            }
        }
    }

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a srt file...");
        log.debug("Processing paragraphs of document...");
        ArrayList<SRTSubtitle> subtitles = new ArrayList<SRTSubtitle>();
        SRTSubtitle current = new SRTSubtitle(this);
        for (Paragraph documentParagraph : document.getParagraphs()) {
            if (!current.getText().toString().trim().isEmpty()) {
                current.getText().append("\n");
            }
            for (StyledSegment styledSegment : documentParagraph.getStyledSegments()) {
                Object object = styledSegment.getSegment();
                if (object instanceof TimestampSegment) {
                    TimestampSegment segment = (TimestampSegment)object;
                    if (current.getStart() == null) {
                        current.setStart(new Date(segment.getMillis()));
                        continue;
                    }
                    if (current.getEnd() != null) continue;
                    current.setEnd(new Date(segment.getMillis()));
                    if (!current.getText().toString().trim().isEmpty()) {
                        subtitles.add(current);
                    }
                    current = new SRTSubtitle(this);
                    continue;
                }
                object = styledSegment.getSegment();
                if (object instanceof SpeakerSegment) {
                    SpeakerSegment speakerSegment = (SpeakerSegment)object;
                    SRTExporter.fixStart((SRTSubtitle)current, subtitles);
                    current.getText().append(speakerSegment.getRealText().trim()).append(": ");
                    continue;
                }
                if (((AbstractSegment)styledSegment.getSegment()).getRealText().trim().isEmpty()) continue;
                SRTExporter.fixStart((SRTSubtitle)current, subtitles);
                current.getText().append(((AbstractSegment)styledSegment.getSegment()).getRealText());
            }
        }
        if (!current.getText().toString().trim().isEmpty()) {
            if (current.getEnd() == null) {
                current.setEnd(new Date(Main.getPlayer().getDuration()));
            }
            subtitles.add(current);
        }
        log.debug("Processed document. Writing to disk ...");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out.toFile()), StandardCharsets.UTF_8));){
            for (int i = 0; i < subtitles.size(); ++i) {
                ((SRTSubtitle)subtitles.get(i)).setId(i + 1);
                writer.write(((SRTSubtitle)subtitles.get(i)).toString() + (i == subtitles.size() - 1 ? "" : "\n\n"));
            }
        }
        log.info("Exported document as srt file.");
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

