/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=6)
@Lazy
public class TXTExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TXTExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Text (*.txt)", new String[]{"*.txt"});

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> doc, Path file) throws IOException {
        log.debug("Exporting document as a txt file...");
        ArrayList<String> lines = new ArrayList<String>();
        for (Paragraph p : doc.getParagraphs()) {
            StringBuilder s = new StringBuilder();
            for (AbstractSegment seg : p.getSegments()) {
                s.append(seg.getRealText());
            }
            lines.add(s.toString());
        }
        Files.write(file, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        log.info("Exported document as txt file.");
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

