/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.VTTExporter;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=5)
@Lazy
public class VTTExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VTTExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("VTT (*.vtt)", new String[]{"*.vtt"});
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS").withZone(ZoneOffset.UTC);

    public void export(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document, Path out) throws Exception {
        log.debug("Starting export of document to VTT format...");
        List cues = this.extractCuesFromDocument(document);
        this.writeCuesToFile(cues, out);
        log.info("Document exported successfully to VTT format.");
    }

    private List<VTTCue> extractCuesFromDocument(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document) {
        ArrayList<VTTCue> cues = new ArrayList<VTTCue>();
        VTTCue cue = new VTTCue();
        log.debug("Processing document paragraphs...");
        for (Paragraph paragraph : document.getParagraphs()) {
            this.appendNewlineIfNotEmpty(cue);
            for (StyledSegment styledSegment : paragraph.getStyledSegments()) {
                cue = this.processSegment(styledSegment, cue, cues);
            }
        }
        if (this.cueHasContent(cue)) {
            this.finalizeCue(cue, cues);
        }
        log.debug("Completed processing document paragraphs.");
        return cues;
    }

    private VTTCue processSegment(StyledSegment<AbstractSegment<?>, TextStyle> segment, VTTCue cue, List<VTTCue> cues) {
        Object object = segment.getSegment();
        if (object instanceof TimestampSegment) {
            TimestampSegment timestampSegment = (TimestampSegment)object;
            return this.processTimestampSegment(timestampSegment, cue, cues);
        }
        object = segment.getSegment();
        if (object instanceof StyledTextSegment) {
            StyledTextSegment styledTextSegment = (StyledTextSegment)object;
            this.handleTextSegment(cues, cue, styledTextSegment);
        } else {
            object = segment.getSegment();
            if (object instanceof SpeakerSegment) {
                SpeakerSegment speakerSegment = (SpeakerSegment)object;
                this.handleSpeakerSegment(cues, cue, speakerSegment);
            } else {
                object = segment.getSegment();
                if (object instanceof LowConfidenceSegment) {
                    LowConfidenceSegment lowConfidenceSegment = (LowConfidenceSegment)object;
                    this.handleLowConfidenceSegment(cues, cue, lowConfidenceSegment);
                }
            }
        }
        return cue;
    }

    private void handleTextSegment(List<VTTCue> cues, VTTCue cue, StyledTextSegment styledTextSegment) {
        this.ensureCueHasStart(cues, cue);
        cue.getText().append(styledTextSegment.getRealText());
    }

    private void handleLowConfidenceSegment(List<VTTCue> cues, VTTCue cue, LowConfidenceSegment lowConfidenceSegment) {
        this.ensureCueHasStart(cues, cue);
        cue.getText().append(lowConfidenceSegment.getRealText());
    }

    private void handleSpeakerSegment(List<VTTCue> cues, VTTCue cue, SpeakerSegment speakerSegment) {
        this.ensureCueHasStart(cues, cue);
        cue.getText().append("<v ").append(speakerSegment.getRealText().trim()).append(">");
    }

    private VTTCue processTimestampSegment(TimestampSegment segment, VTTCue current, List<VTTCue> cues) {
        if (current.getStart() == null) {
            current.setStart(new Date(segment.getMillis()));
        } else if (current.getEnd() == null) {
            current.setEnd(new Date(segment.getMillis()));
            if (this.cueHasContent(current)) {
                cues.add(current);
            }
            current = new VTTCue();
        }
        return current;
    }

    private void ensureCueHasStart(List<VTTCue> cues, VTTCue cue) {
        if (cue.getStart() == null) {
            log.debug("No start time found for cue. Setting to previous cue's end or beginning.");
            cue.setStart(this.getPreviousCueEndTime(cues));
        }
    }

    private Date getPreviousCueEndTime(List<VTTCue> cues) {
        return cues.isEmpty() ? new Date(0L) : cues.getLast().getEnd();
    }

    private void appendNewlineIfNotEmpty(VTTCue cue) {
        if (this.cueHasContent(cue) && !cue.getText().toString().endsWith("\n")) {
            cue.getText().append("\n");
        }
    }

    private boolean cueHasContent(VTTCue cue) {
        return !cue.getText().isEmpty();
    }

    private void finalizeCue(VTTCue cue, List<VTTCue> cues) {
        if (cue.getEnd() == null) {
            long duration = Main.getPlayer() != null ? Main.getPlayer().getDuration() : 0L;
            cue.setEnd(new Date(duration));
        }
        cues.add(cue);
    }

    private void writeCuesToFile(List<VTTCue> cues, Path out) throws Exception {
        log.debug("Writing cues to VTT file...");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out.toFile()), StandardCharsets.UTF_8));){
            writer.write("WEBVTT\n\n");
            for (int i = 0; i < cues.size(); ++i) {
                VTTCue cue = cues.get(i);
                cue.setId(i + 1);
                writer.write(cue.toString());
                if (i >= cues.size() - 1) continue;
                writer.write("\n\n");
            }
        }
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

