/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TextStyleService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import jakarta.annotation.PostConstruct;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.apache.poi.EmptyFileException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class DOCXImporter
extends DocumentImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DOCXImporter.class);
    private final MessageService messageService;
    private final TranscriptService transcriptService;
    private FileChooser.ExtensionFilter filter;

    public DOCXImporter(MessageService messageService, TextStyleService textStyleService, TranscriptService transcriptService) {
        super(textStyleService);
        this.messageService = messageService;
        this.transcriptService = transcriptService;
    }

    @PostConstruct
    public void setup() {
        this.filter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("formats.docx") + " (*.docx)", new String[]{"*.docx"});
    }

    public void importTranscript(Path file, String timestampFormat) throws Exception {
        log.debug("Importing docx file as a transcript document...");
        TimestampProcessor timestampProcessor = new TimestampProcessor(timestampFormat);
        Document document = this.createDocument();
        Element body = this.createCaseSensitiveElement("StyledDocument");
        document.appendChild((Node)body);
        try (XWPFDocument xwpfDocument = new XWPFDocument((InputStream)new FileInputStream(file.toFile()));){
            for (XWPFParagraph paragraph : xwpfDocument.getParagraphs()) {
                Element para = this.createCaseSensitiveElement("Paragraph");
                body.appendChild((Node)para);
                for (XWPFRun run : paragraph.getRuns()) {
                    ETStyle etStyle = this.textStyleService.getETStyleWithDefaults(this.getStyle(xwpfDocument, run));
                    String content = run.text();
                    if (content.isEmpty()) {
                        log.debug("Run appears to be empty. Searching for emoji.");
                        Document doc = Jsoup.parse((String)run.getCTR().xmlText(), (String)"", (Parser)Parser.xmlParser());
                        Elements elements = doc.getElementsByTag("w16se:symEx");
                        if (!elements.isEmpty()) {
                            log.debug("Found tag for emoji.");
                            Element symEx = (Element)elements.getFirst();
                            String font = symEx.attr("w16se:font");
                            if (!font.isEmpty()) {
                                etStyle.setFontFamily(font);
                            }
                            String chara = symEx.attr("w16se:char");
                            try {
                                content = new String(Character.toChars(Integer.parseInt(chara, 16)));
                            }
                            catch (NumberFormatException e) {
                                log.warn("Apparently this run doesn't include emoji after all. An invalid string was found for the assumed Unicode attribute.", (Throwable)e);
                            }
                        }
                    }
                    this.processText(para, content, etStyle, timestampProcessor);
                }
            }
            this.optimize((Element)document);
            log.debug("Creating transcriptTextArea document.");
            this.transcriptService.getCurrentTranscript().setDocument(this.documentToString(document));
        }
        catch (EmptyFileException e) {
            log.error("File seems to be empty.");
            throw new IOException(this.messageService.getLocaleBundle().getString("problems.poiEmptyFile"));
        }
        catch (NotOfficeXmlFileException e) {
            log.error("File is not a valid docx document.");
            throw new IOException(this.messageService.getLocaleBundle().getString("problems.invalidPoiFile"));
        }
        catch (Exception e) {
            log.error("Could not import docx document.");
            throw e;
        }
        log.info("Imported docx file as a transcript document.");
    }

    private ETStyle getStyle(XWPFDocument doc, XWPFRun run) {
        CTRPr rPr;
        ETStyle etStyle = new ETStyle();
        etStyle.setBold(run.isBold());
        etStyle.setItalic(run.isItalic());
        etStyle.setUnderlined(run.getUnderline() != UnderlinePatterns.NONE);
        etStyle.setFontFamily(run.getFontFamily());
        Double fontSize = run.getFontSizeAsDouble();
        if (fontSize != null) {
            etStyle.setFontSize(fontSize.intValue());
        }
        if ((rPr = run.getCTR().getRPr()) != null && rPr.getRStyleArray().length > 0 && rPr.getRStyleArray(0) != null) {
            String styleId;
            XWPFStyle style = doc.getStyles().getStyle(rPr.getRStyleArray(0).getVal());
            String string = styleId = style != null ? style.getStyleId() : null;
            while (styleId != null) {
                style = doc.getStyles().getStyle(styleId);
                if (style != null) {
                    String family;
                    int size;
                    if (etStyle.getFontSize().isEmpty() && (size = this.getFontSize(style.getCTStyle().getRPr())) > -1) {
                        etStyle.setFontSize(size);
                    }
                    if (etStyle.getFontFamily().isEmpty() && (family = this.getFontFamily(style.getCTStyle().getRPr())) != null) {
                        etStyle.setFontFamily(family);
                    }
                    if (etStyle.getFontFamily().isPresent() && etStyle.getFontSize().isPresent()) break;
                    styleId = style.getBasisStyleID();
                    continue;
                }
                styleId = null;
            }
        }
        return etStyle;
    }

    private int getFontSize(CTRPr pr) {
        if (pr == null || pr.getSzArray() == null) {
            return -1;
        }
        return (Integer)pr.getSzArray(0).getVal() / 2;
    }

    private String getFontFamily(CTRPr pr) {
        if (pr == null || pr.getRFontsArray().length == 0) {
            return null;
        }
        CTFonts fonts = pr.getRFontsArray(0);
        return fonts.getAscii();
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

