/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.io.importers.Importer;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.service.TextStyleService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentImporter
implements Importer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentImporter.class);
    private static final Pattern pattern = Pattern.compile("[HmSs]");
    private final ParseSettings parseSettings = new ParseSettings(true, true);
    private final Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(true).indentAmount(0);
    protected final TextStyleService textStyleService;

    protected DocumentImporter(TextStyleService textStyleService) {
        this.textStyleService = textStyleService;
    }

    static String getRegexForTimestamp(String timestampFormat) {
        int currentIndex = 0;
        ArrayList<String> parts = new ArrayList<String>();
        while (currentIndex != timestampFormat.length()) {
            int end;
            int start = timestampFormat.indexOf("'", currentIndex);
            if (start == -1) {
                start = timestampFormat.length();
            }
            if (currentIndex != start) {
                parts.add(timestampFormat.substring(currentIndex, start));
                if (start == timestampFormat.length()) break;
            }
            if ((end = timestampFormat.indexOf("'", start + 1)) == -1) {
                parts.add(timestampFormat.substring(start));
                break;
            }
            parts.add(timestampFormat.substring(start, end + 1));
            currentIndex = end + 1;
        }
        StringBuilder returner = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            if (!((String)parts.get(i)).startsWith("'")) {
                parts.set(i, pattern.matcher((CharSequence)parts.get(i)).replaceAll("[0-9]"));
            }
            returner.append((String)parts.get(i));
        }
        return returner.toString();
    }

    void optimize(Element document) {
        log.debug("Optimizing document...");
        double childCountInitial = document.getAllElements().size();
        log.debug("Removing all illegal tags missed in previous steps...");
        document.getAllElements().stream().filter(f -> !f.tagName().equals("StyledDocument") && !f.tagName().equals("StyledText") && !f.tagName().equals("Timestamp") && !f.tagName().equals("Paragraph") && !f.tagName().equals("lct") && !f.tagName().equals("Speaker")).forEach(node -> {
            log.debug("Illegal node with tag \"{}\"", (Object)node.tag());
            if (node.parent() != null) {
                node.remove();
            }
        });
        log.debug("Removed all illegal tags missed in previous steps.");
        this.expandStylesToAllAttributes(document);
        document.getElementsByTag("Paragraph").forEach(f -> {
            Elements children = f.children();
            String currentStyle = null;
            Element currentChild = null;
            ArrayList<Element> elementsOfEqualStyle = new ArrayList<Element>();
            for (Element child : children) {
                String style = child.hasAttr("style") ? child.attr("style") : child.attr("style", this.textStyleService.getETStyleWithDefaults(new ETStyle()).toString()).attr("style");
                if (currentChild == null || child.tagName().equals("Timestamp") || child.tagName().equals("lct") || child.tagName().equals("Speaker") || !style.equals(currentStyle)) {
                    if (currentChild != null) {
                        String toAdd = elementsOfEqualStyle.stream().map(Element::wholeText).collect(Collectors.joining(""));
                        elementsOfEqualStyle.forEach(Node::remove);
                        currentChild.text(currentChild.wholeText() + toAdd);
                        elementsOfEqualStyle.clear();
                    }
                    currentStyle = style;
                    currentChild = child;
                    continue;
                }
                elementsOfEqualStyle.add(child);
            }
            if (!elementsOfEqualStyle.isEmpty()) {
                String toAdd = elementsOfEqualStyle.stream().map(Element::wholeText).collect(Collectors.joining(""));
                elementsOfEqualStyle.forEach(Node::remove);
                currentChild.text(currentChild.wholeText() + toAdd);
                elementsOfEqualStyle.clear();
            }
        });
        log.debug("All sequences of StyledTexts with the identical style summarized within a paragraph.");
        document.getAllElements().stream().filter(f -> (f.tagName().equals("StyledText") || f.tagName().equals("Paragraph")) && f.childNodeSize() == 0).forEach(Node::remove);
        double newCount = document.getAllElements().size();
        log.debug("Optimization completed. Reduced element count from {} to {} ({}% reduction).", new Object[]{(int)childCountInitial, (int)newCount, String.format("%.2f", 100.0 - newCount / childCountInitial * 100.0)});
    }

    ETStyle parseStyle(String style) {
        String[] pairs;
        ETStyle etStyle = new ETStyle();
        if (style.trim().isEmpty()) {
            return etStyle;
        }
        block23: for (String pair : pairs = style.split(";")) {
            String[] split = pair.split(":");
            String value = split[1].trim();
            switch (split[0]) {
                case "font-family": 
                case "-fx-font-family": {
                    etStyle.setFontFamily(value);
                    continue block23;
                }
                case "-fx-font-style": 
                case "font-style": {
                    etStyle.setItalic(value.equals("italic"));
                    continue block23;
                }
                case "-fx-font-weight": {
                    etStyle.setBold(value.equals("bold"));
                    continue block23;
                }
                case "font-weight": {
                    etStyle.setBold(!value.equals("normal"));
                    continue block23;
                }
                case "-fx-font-size": 
                case "font-size": {
                    etStyle.setFontSize((int)Double.parseDouble(value.substring(0, value.length() - 2).trim()));
                    continue block23;
                }
                case "-fx-underline": {
                    etStyle.setUnderlined(value.equals("true"));
                    continue block23;
                }
                case "text-decoration": {
                    etStyle.setUnderlined(value.equals("underline"));
                    continue block23;
                }
                case "-fx-fill": {
                    etStyle.setColor(value);
                    continue block23;
                }
            }
        }
        return this.textStyleService.getETStyleWithDefaults(etStyle);
    }

    void expandStylesToAllAttributes(Element newBody) {
        newBody.getElementsByTag("StyledText").forEach(f -> f.attr("style", this.parseStyle(f.attr("style")).toFullString()));
        log.debug("Expanded all style specifications to full style specifications with all necessary value pairs.");
    }

    String documentToString(Document document) {
        return document.toString().replace("&nbsp;", " ").replace("\r", "").replace("\n", "");
    }

    Document createDocument() {
        Document document = new Document("");
        document.outputSettings(this.outputSettings);
        return document;
    }

    Element createCaseSensitiveElement(String tag) {
        return new Element(Tag.valueOf((String)tag, (ParseSettings)this.parseSettings), "");
    }

    protected void processText(Element paragraph, String content, ETStyle etStyle, TimestampProcessor timestampProcessor) {
        List contentParts = timestampProcessor.getContentParts(content);
        log.debug("Found {} content parts. {} of them timestamps.", (Object)contentParts.size(), (Object)contentParts.stream().filter(TimestampProcessor.TimestampContent.class::isInstance).toList().size());
        TextStyle textStyle = this.textStyleService.resolveETStyle(etStyle);
        String styleString = textStyle.toCss();
        for (TimestampProcessor.Content contentPart : contentParts) {
            if (contentPart instanceof TimestampProcessor.TextContent) {
                Element styledText = this.createCaseSensitiveElement("StyledText");
                paragraph.appendChild((Node)styledText);
                styledText.attr("style", styleString);
                styledText.text(contentPart.getValue());
                continue;
            }
            if (!(contentPart instanceof TimestampProcessor.TimestampContent)) continue;
            TimestampProcessor.TimestampContent timestampContent = (TimestampProcessor.TimestampContent)contentPart;
            Element timestamp = this.createCaseSensitiveElement("Timestamp");
            timestamp.attr("ms", timestampContent.getValue());
            paragraph.appendChild((Node)timestamp);
        }
    }
}

