/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ETStyle {
    private Optional<String> fontFamily = Optional.empty();
    private Optional<Integer> fontSize = Optional.empty();
    private Optional<Boolean> bold = Optional.empty();
    private Optional<Boolean> italic = Optional.empty();
    private Optional<Boolean> underlined = Optional.empty();
    private Optional<String> color = Optional.empty();

    public String toFullString() {
        StringBuilder builder = new StringBuilder();
        this.fontFamily.ifPresent(f -> builder.append("-fx-font-family: ").append((String)f).append(";"));
        this.fontSize.ifPresent(f -> builder.append("-fx-font-size: ").append(f).append("px;"));
        this.bold.ifPresent(f -> builder.append("-fx-font-weight: ").append(f != false ? "bold" : "normal").append(";"));
        this.italic.ifPresent(f -> builder.append("-fx-font-style: ").append(f != false ? "italic" : "normal").append(";"));
        this.underlined.ifPresent(f -> builder.append("-fx-underline: ").append(f).append(";"));
        this.color.ifPresent(f -> builder.append("-fx-fill: ").append((String)f).append(";"));
        return builder.toString();
    }

    public String toString() {
        return this.toFullString();
    }

    public Optional<Boolean> getBold() {
        return this.bold;
    }

    public Optional<Boolean> getItalic() {
        return this.italic;
    }

    public Optional<Boolean> getUnderlined() {
        return this.underlined;
    }

    public Optional<String> getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = Optional.ofNullable(fontFamily);
    }

    public Optional<Integer> getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = Optional.of(fontSize);
    }

    public Optional<Boolean> isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = Optional.of(bold);
    }

    public Optional<Boolean> isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = Optional.of(italic);
    }

    public Optional<Boolean> isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = Optional.of(underlined);
    }

    public Optional<String> getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = Optional.ofNullable(color);
    }

    public void overwriteWith(ETStyle other) {
        if (this.fontFamily.isEmpty() && other.fontFamily.isPresent()) {
            this.fontFamily = other.fontFamily;
        }
        if (this.fontSize.isEmpty() && other.fontSize.isPresent()) {
            this.fontSize = other.fontSize;
        }
        if (this.bold.isEmpty() && other.bold.isPresent()) {
            this.bold = other.bold;
        }
        if (this.italic.isEmpty() && other.italic.isPresent()) {
            this.italic = other.italic;
        }
        if (this.underlined.isEmpty() && other.underlined.isPresent()) {
            this.underlined = other.underlined;
        }
        if (this.color.isEmpty() && other.color.isPresent()) {
            this.color = other.color;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETStyle etStyle = (ETStyle)o;
        return Objects.equals(this.fontFamily, etStyle.fontFamily) && Objects.equals(this.fontSize, etStyle.fontSize) && Objects.equals(this.bold, etStyle.bold) && Objects.equals(this.italic, etStyle.italic) && Objects.equals(this.underlined, etStyle.underlined) && Objects.equals(this.color, etStyle.color);
    }

    public int hashCode() {
        return Objects.hash(this.fontFamily, this.fontSize, this.bold, this.italic, this.underlined, this.color);
    }

    @Generated
    public ETStyle() {
    }
}

