/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TextStyleService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Component
@Lazy
public class ODTImporter
extends DocumentImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODTImporter.class);
    private final MessageService messageService;
    private final List<OdfElement> whitespaces = new ArrayList();
    private final TranscriptService transcriptService;
    private TimestampProcessor timestampProcessor;
    private ETStyle latestStyle = this.textStyleService.getETStyleWithDefaults(new ETStyle());
    private FileChooser.ExtensionFilter filter;

    public ODTImporter(MessageService messageService, TextStyleService textStyleService, TranscriptService transcriptService) {
        super(textStyleService);
        this.messageService = messageService;
        this.transcriptService = transcriptService;
    }

    @PostConstruct
    public void setup() {
        this.filter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("formats.odt") + " (*.odt)", new String[]{"*.odt"});
    }

    public void importTranscript(Path file, String timestampFormat) throws Exception {
        log.debug("Importing odt file as a transcript document...");
        this.timestampProcessor = new TimestampProcessor(timestampFormat);
        try (OdfDocument document = OdfDocument.loadDocument((File)file.toFile());){
            Document domDocument = this.createDocument();
            Element body = this.createCaseSensitiveElement("StyledDocument");
            domDocument.appendChild((Node)body);
            this.processContent((org.w3c.dom.Node)document.getContentRoot(), body);
            this.optimize((Element)domDocument);
            log.debug("Creating transcriptTextArea document.");
            this.transcriptService.getCurrentTranscript().setDocument(this.documentToString(domDocument));
        }
        catch (Exception e) {
            log.error("Could not import odt document.", (Throwable)e);
            throw e;
        }
        log.info("Imported odt file as a transcript document.");
    }

    private void processContent(org.w3c.dom.Node root, Element domElement) {
        NodeList nodes = root.getChildNodes();
        block8: for (int i = 0; i < nodes.getLength(); ++i) {
            org.w3c.dom.Node node;
            org.w3c.dom.Node node2 = nodes.item(i);
            if (node2.getNodeType() != 1 && node2.getNodeType() != 3) continue;
            Objects.requireNonNull(node2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextPElement.class, TextSElement.class, TextLineBreakElement.class, TextTabElement.class, TextSpanElement.class, Text.class}, (org.w3c.dom.Node)node, n)) {
                case 0: {
                    TextPElement textPElement = (TextPElement)node;
                    Element paragraph = this.createCaseSensitiveElement("Paragraph");
                    domElement.appendChild((Node)paragraph);
                    this.processContent(node2, paragraph);
                    continue block8;
                }
                case 1: {
                    TextSElement textSElement = (TextSElement)node;
                    this.whitespaces.add(textSElement);
                    continue block8;
                }
                case 2: {
                    TextLineBreakElement textLineBreakElement = (TextLineBreakElement)node;
                    this.whitespaces.add(textLineBreakElement);
                    continue block8;
                }
                case 3: {
                    TextTabElement textTabElement = (TextTabElement)node;
                    this.whitespaces.add(textTabElement);
                    continue block8;
                }
                case 4: {
                    TextSpanElement textSpanElement = (TextSpanElement)node;
                    OdfStyle automaticStyle = textSpanElement.getAutomaticStyle();
                    this.latestStyle = this.getETStyle(automaticStyle);
                    this.processContent(node2, domElement);
                    continue block8;
                }
                case 5: {
                    Text text = (Text)node;
                    String content = this.processWhitespaces() + node2.getTextContent();
                    this.processText(domElement, content, this.latestStyle, this.timestampProcessor);
                    continue block8;
                }
                default: {
                    this.processContent(node2, domElement);
                }
            }
        }
    }

    private String processWhitespaces() {
        StringBuilder stringBuilder = new StringBuilder();
        this.whitespaces.forEach(node -> {
            if (node instanceof TextSElement) {
                stringBuilder.append(" ");
            } else if (node instanceof TextLineBreakElement) {
                stringBuilder.append("\n");
            } else if (node instanceof TextTabElement) {
                stringBuilder.append("\t");
            }
        });
        this.whitespaces.clear();
        return stringBuilder.toString();
    }

    private ETStyle getETStyle(OdfStyle automaticStyle) {
        if (automaticStyle == null) {
            return this.textStyleService.getETStyleWithDefaults(new ETStyle());
        }
        Map propertiesElement = automaticStyle.getStylePropertiesDeep();
        ETStyle etStyle = this.textStyleService.getETStyleWithDefaults(new ETStyle());
        propertiesElement.forEach((a, b) -> {
            if (a.getPropertySet() == OdfStylePropertiesSet.TextProperties) {
                switch (a.getName().getLocalName()) {
                    case "font-size": {
                        etStyle.setFontSize(this.cssLikeToInt(b));
                        break;
                    }
                    case "font-name": {
                        etStyle.setFontFamily(b);
                        break;
                    }
                    case "font-weight": {
                        etStyle.setBold(b.equals("bold"));
                        break;
                    }
                    case "font-style": {
                        etStyle.setItalic(b.equals("italic"));
                        break;
                    }
                    case "text-underline-type": {
                        etStyle.setUnderlined(b != null);
                        break;
                    }
                }
            }
        });
        return etStyle;
    }

    private int cssLikeToInt(String b) {
        return Double.valueOf(Double.parseDouble(b.replaceAll("[a-zA-Z]", ""))).intValue();
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

