/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import eu.ewerkzeug.easytranscript3.service.TextStyleService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class TXTImporter
extends DocumentImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TXTImporter.class);
    private final TranscriptService transcriptService;
    private FileChooser.ExtensionFilter filter;

    public TXTImporter(TextStyleService textStyleService, TranscriptService transcriptService) {
        super(textStyleService);
        this.transcriptService = transcriptService;
    }

    @PostConstruct
    public void setup() {
        this.filter = new FileChooser.ExtensionFilter("Text (*.txt)", new String[]{"*.txt"});
    }

    public void importTranscript(Path file, String timestampFormat) throws Exception {
        log.debug("Importing txt file as a transcript document...");
        TimestampProcessor timestampProcessor = new TimestampProcessor(timestampFormat);
        Document document = this.createDocument();
        Element body = this.createCaseSensitiveElement("StyledDocument");
        document.appendChild((Node)body);
        try (Stream<String> stream = Files.lines(file, StandardCharsets.UTF_8);){
            stream.forEach(line -> {
                Element paragraph = this.createCaseSensitiveElement("Paragraph");
                body.appendChild((Node)paragraph);
                this.processText(paragraph, line, this.textStyleService.getETStyleWithDefaults(new ETStyle()), timestampProcessor);
            });
        }
        catch (IOException e) {
            log.error("Could not read txt file.", (Throwable)e);
            throw e;
        }
        this.optimize((Element)document);
        log.debug("Creating transcriptTextArea document.");
        this.transcriptService.getCurrentTranscript().setDocument(this.documentToString(document));
        log.info("Imported txt file as a transcript document.");
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

